<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\SubDivisionDetail;
use App\Models\Project;
use App\Models\ProjectClient;
use Illuminate\Foundation\Testing\RefreshDatabase;
use PHPUnit\Framework\Attributes\Test;

class SubDivisionDetailTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_create_a_subdivision_detail()
    {
        $client = ProjectClient::factory()->create();
        $subdivision = SubDivisionDetail::factory()->forClient($client)->create();

        $this->assertDatabaseHas('sub_division_details', [
            'id' => $subdivision->id,
            'plot_number' => $subdivision->plot_number,
            'project_client_id' => $client->id,
            'project_id' => $client->project_id,
        ]);
    }

    #[Test]
    public function it_can_update_a_subdivision_detail()
    {
        $client = ProjectClient::factory()->create();
        $subdivision = SubDivisionDetail::factory()->forClient($client)->create([
            'size' => 200,
        ]);

        $subdivision->update([
            'size' => 300,
        ]);

        $this->assertDatabaseHas('sub_division_details', [
            'id' => $subdivision->id,
            'size' => 300,
        ]);
    }

    #[Test]
    public function it_can_soft_delete_a_subdivision_detail()
    {
        $client = ProjectClient::factory()->create();
        $subdivision = SubDivisionDetail::factory()->forClient($client)->create();

        $subdivision->delete();

        $this->assertSoftDeleted('sub_division_details', [
            'id' => $subdivision->id,
        ]);
    }

    #[Test]
    public function a_subdivision_detail_belongs_to_a_project()
    {
        $client = ProjectClient::factory()->create();
        $subdivision = SubDivisionDetail::factory()->forClient($client)->create();

        $this->assertInstanceOf(Project::class, $subdivision->project);
        $this->assertEquals($client->project_id, $subdivision->project->id);
    }

    #[Test]
    public function a_subdivision_detail_belongs_to_a_project_client()
    {
        $client = ProjectClient::factory()->create();
        $subdivision = SubDivisionDetail::factory()->forClient($client)->create();

        $this->assertInstanceOf(ProjectClient::class, $subdivision->projectClient);
        $this->assertEquals($client->id, $subdivision->projectClient->id);
        $this->assertEquals($client->project_id, $subdivision->project_id);
    }
}
