<?php

namespace Tests\Unit;

use App\Models\Employee;
use App\Models\Salary;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;

class SalaryTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_has_fillable_attributes()
    {
        $salary = new Salary();

        $this->assertEqualsCanonicalizing([
            'employee_id',
            'amount',
            'period',
        ], $salary->getFillable());
    }

    #[Test]
    public function it_belongs_to_an_employee()
    {
        $employee = Employee::factory()->create();
        $salary = Salary::factory()->create([
            'employee_id' => $employee->id,
        ]);

        $this->assertInstanceOf(Employee::class, $salary->employee);
        $this->assertEquals($employee->id, $salary->employee->id);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        $salary = Salary::factory()->create();
        $salary->delete();

        $this->assertSoftDeleted('salaries', ['id' => $salary->id]);
    }

    #[Test]
    public function it_can_set_period_correctly()
    {
        $salary = Salary::factory()->create([
            'period' => '2025-08',
        ]);

        $this->assertEquals('2025-08', $salary->period);
    }
}