<?php

namespace Tests\Unit;

use App\Models\Project;
use App\Models\ProjectExpense;
use App\Models\Expense;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;

class ProjectExpenseTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_has_fillable_attributes()
    {
        $projectExpense = new ProjectExpense();

        $this->assertEqualsCanonicalizing([
            'project_id',
            'expense_id',
        ], $projectExpense->getFillable());
    }

    #[Test]
    public function it_belongs_to_a_project()
    {
        $project = Project::factory()->create();
        $expense = Expense::factory()->forProject($project)->create();
        $projectExpense = ProjectExpense::factory()->create([
            'project_id' => $project->id,
            'expense_id' => $expense->id,
        ]);

        $this->assertInstanceOf(Project::class, $projectExpense->project);
        $this->assertEquals($project->id, $projectExpense->project->id);
    }

    #[Test]
    public function it_belongs_to_an_expense()
    {
        $project = Project::factory()->create();
        $expense = Expense::factory()->forProject($project)->create();
        $projectExpense = ProjectExpense::factory()->create([
            'project_id' => $project->id,
            'expense_id' => $expense->id,
        ]);

        $this->assertInstanceOf(Expense::class, $projectExpense->expense);
        $this->assertEquals($expense->id, $projectExpense->expense->id);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        $project = Project::factory()->create();
        $expense = Expense::factory()->forProject($project)->create();
        $projectExpense = ProjectExpense::factory()->create([
            'project_id' => $project->id,
            'expense_id' => $expense->id,
        ]);
        $projectExpense->delete();

        $this->assertSoftDeleted('project_expenses', ['id' => $projectExpense->id]);
    }
}