<?php

namespace Tests\Unit;

use App\Models\ProjectClient;
use App\Models\ProjectClientPayment;
use App\Models\Payment;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;

class ProjectClientPaymentTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_has_fillable_attributes()
    {
        $projectClientPayment = new ProjectClientPayment();

        $this->assertEqualsCanonicalizing([
            'project_client_id',
            'amount_paid',
            'payment_id',
            'payment_method',
            'transaction_id',
            'status',
        ], $projectClientPayment->getFillable());
    }

    #[Test]
    public function it_belongs_to_a_project_client()
    {
        $projectClient = ProjectClient::factory()->create();
        $projectClientPayment = ProjectClientPayment::factory()->forProjectClient($projectClient)->create();

        $this->assertInstanceOf(ProjectClient::class, $projectClientPayment->projectClient);
        $this->assertEquals($projectClient->id, $projectClientPayment->projectClient->id);
    }

    #[Test]
    public function it_belongs_to_a_payment()
    {
        $projectClient = ProjectClient::factory()->create();
        $projectClientPayment = ProjectClientPayment::factory()->forProjectClient($projectClient)->create();

        $this->assertInstanceOf(Payment::class, $projectClientPayment->payment);
        $this->assertEquals($projectClientPayment->payment_id, $projectClientPayment->payment->id);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        $projectClientPayment = ProjectClientPayment::factory()->create();
        $projectClientPayment->delete();

        $this->assertSoftDeleted('project_client_payments', ['id' => $projectClientPayment->id]);
    }
}