<?php

namespace Tests\Unit;

use App\Models\OfficeUtility;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;


class OfficeUtilityTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_create_an_office_utility()
    {
        $utility = OfficeUtility::factory()->create([
            'type'   => 'Electricity',
            'amount' => 5000,
            'period' => '2025-08',
        ]);

        $this->assertDatabaseHas('office_utilities', [
            'id'     => $utility->id,
            'type'   => 'Electricity',
            'amount' => 5000,
            'period' => '2025-08',
        ]);
    }

    #[Test]
    public function it_can_update_an_office_utility()
    {
        $utility = OfficeUtility::factory()->create();

        $utility->update([
            'type'   => 'Water',
            'amount' => 7500,
        ]);

        $this->assertDatabaseHas('office_utilities', [
            'id'     => $utility->id,
            'type'   => 'Water',
            'amount' => 7500,
        ]);
    }

    #[Test]
    public function it_can_soft_delete_an_office_utility()
    {
        $utility = OfficeUtility::factory()->create();

        $utility->delete();

        $this->assertSoftDeleted('office_utilities', [
            'id' => $utility->id,
        ]);
    }

    #[Test]
    public function it_has_fillable_attributes()
    {
        $utility = new OfficeUtility();

        $this->assertEquals(['type', 'amount', 'period'], $utility->getFillable());
    }
}
