<?php

namespace Tests\Unit;

use App\Models\Client;
use App\Models\Litigation;
use App\Models\LitigationPayment;
use App\Models\Payment;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;

class LitigationPaymentTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_create_a_litigation_payment()
    {
        $litigation = Litigation::factory()->create();
        $payment = Payment::factory()->forLitigation($litigation)->create();

        $litigationPayment = LitigationPayment::factory()->create([
            'litigation_id' => $litigation->id,
            'payment_id' => $payment->id,
        ]);

        $this->assertDatabaseHas('litigation_payments', [
            'id' => $litigationPayment->id,
            'litigation_id' => $litigation->id,
            'payment_id' => $payment->id,
        ]);
    }

    #[Test]
    public function it_belongs_to_a_litigation()
    {
        $litigation = Litigation::factory()->create();
        $payment = Payment::factory()->forLitigation($litigation)->create();

        $litigationPayment = LitigationPayment::factory()->create([
            'litigation_id' => $litigation->id,
            'payment_id' => $payment->id,
        ]);

        $this->assertInstanceOf(Litigation::class, $litigationPayment->litigation);
        $this->assertEquals($litigation->id, $litigationPayment->litigation->id);
    }

    #[Test]
    public function it_belongs_to_a_payment()
    {
        $litigation = Litigation::factory()->create();
        $payment = Payment::factory()->forLitigation($litigation)->create();

        $litigationPayment = LitigationPayment::factory()->create([
            'litigation_id' => $litigation->id,
            'payment_id' => $payment->id,
        ]);

        $this->assertInstanceOf(Payment::class, $litigationPayment->payment);
        $this->assertEquals($payment->id, $litigationPayment->payment->id);
    }

    #[Test]
    public function it_can_soft_delete_a_litigation_payment()
    {
        $litigation = Litigation::factory()->create();
        $payment = Payment::factory()->forLitigation($litigation)->create();

        $litigationPayment = LitigationPayment::factory()->create([
            'litigation_id' => $litigation->id,
            'payment_id' => $payment->id,
        ]);

        $litigationPayment->delete();

        $this->assertSoftDeleted('litigation_payments', [
            'id' => $litigationPayment->id,
        ]);
    }
}
