<?php

namespace Tests\Unit;

use App\Models\Employee;
use Illuminate\Foundation\Testing\RefreshDatabase;
use PHPUnit\Framework\Attributes\Test;
use Tests\TestCase;

class EmployeeTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_be_created_using_factory()
    {
        // Create an Employee instance using the factory
        $employee = Employee::factory()->create();

        // Assert that the record exists in the database
        $this->assertDatabaseHas('employees', [
            'name' => $employee->name,
            'email' => $employee->email,
            'employee_id' => $employee->employee_id,
        ]);

        // Assert the fields are correctly set
        $this->assertNotNull($employee->name);
        $this->assertNotNull($employee->email);
        $this->assertNotNull($employee->employee_id);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        // Create an Employee instance
        $employee = Employee::factory()->create();

        // Soft delete the employee
        $employee->delete();

        // Assert the employee is soft deleted
        $this->assertSoftDeleted($employee);
    }
}