<?php

namespace Tests\Unit;

use App\Models\ConveyancingPayment;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;


class ConveyancingPaymentTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_be_created_using_factory()
    {
        // Create a ConveyancingPayment instance using the factory
        $conveyancingPayment = ConveyancingPayment::factory()->create();

        // Assert that the record exists in the database
        $this->assertDatabaseHas('conveyancing_payments', [
            'client_id' => $conveyancingPayment->client_id,
            'conveyancing_id' => $conveyancingPayment->conveyancing_id,
            'amount_paid' => $conveyancingPayment->amount_paid,
            'payment_method' => $conveyancingPayment->payment_method,
            'transaction_id' => $conveyancingPayment->transaction_id,
            'status' => $conveyancingPayment->status,
            'type' => $conveyancingPayment->type,
            'payment_id' => $conveyancingPayment->payment_id,
            'paid_by' => $conveyancingPayment->paid_by,
        ]);

        // Assert relationships are loaded correctly
        $this->assertNotNull($conveyancingPayment->client);
        $this->assertNotNull($conveyancingPayment->conveyancing);
        $this->assertNotNull($conveyancingPayment->payment);
        $this->assertNotNull($conveyancingPayment->paidBy);
    }

    #[Test]
    public function it_belongs_to_client()
    {
        $conveyancingPayment = ConveyancingPayment::factory()->create();

        $this->assertInstanceOf('App\Models\Client', $conveyancingPayment->client);
    }

    #[Test]
    public function it_belongs_to_conveyancing()
    {
        $conveyancingPayment = ConveyancingPayment::factory()->create();

        $this->assertInstanceOf('App\Models\Conveyancing', $conveyancingPayment->conveyancing);
    }

    #[Test]
    public function it_belongs_to_payment()
    {
        $conveyancingPayment = ConveyancingPayment::factory()->create();

        $this->assertInstanceOf('App\Models\Payment', $conveyancingPayment->payment);
    }

    #[Test]
    public function it_belongs_to_paid_by_client()
    {
        $conveyancingPayment = ConveyancingPayment::factory()->create();

        $this->assertInstanceOf('App\Models\Client', $conveyancingPayment->paidBy);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        $conveyancingPayment = ConveyancingPayment::factory()->create();
        $conveyancingPayment->delete();

        $this->assertSoftDeleted($conveyancingPayment);
    }
}