<?php

namespace Tests\Unit;

use App\Models\ConveyancingExpense;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use PHPUnit\Framework\Attributes\Test;

class ConveyancingExpenseTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_be_created_using_factory()
    {
        // Create a ConveyancingExpense instance using the factory
        // (this assumes Conveyancing, Expense, and ExpenseItem factories exist and create related records)
        $conveyancingExpense = ConveyancingExpense::factory()->create();

        // Assert that the record exists in the database
        $this->assertDatabaseHas('conveyancing_expenses', [
            'conveyancing_id' => $conveyancingExpense->conveyancing_id,
            'expense_id' => $conveyancingExpense->expense_id,
        ]);

        // Optionally, assert relationships are loaded correctly
        $this->assertNotNull($conveyancingExpense->conveyancing);
        $this->assertNotNull($conveyancingExpense->expense);
    }

    #[Test]
    public function it_belongs_to_conveyancing()
    {
        $conveyancingExpense = ConveyancingExpense::factory()->create();

        $this->assertInstanceOf('App\Models\Conveyancing', $conveyancingExpense->conveyancing);
    }

    #[Test]
    public function it_belongs_to_expense()
    {
        $conveyancingExpense = ConveyancingExpense::factory()->create();

        $this->assertInstanceOf('App\Models\Expense', $conveyancingExpense->expense);
    }

    #[Test]
    public function it_can_be_soft_deleted()
    {
        $conveyancingExpense = ConveyancingExpense::factory()->create();
        $conveyancingExpense->delete();

        $this->assertSoftDeleted($conveyancingExpense);
    }
}