<?php

namespace Tests\Unit;

use App\Models\{
    Advocate,
    Conveyancing,
    ConveyancingAdvocate
};
use Illuminate\Foundation\Testing\RefreshDatabase;
use PHPUnit\Framework\Attributes\Test;
use Tests\TestCase;

class ConveyancingAdvocateTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_create_a_conveyancing_advocate()
    {
        $conveyancing = Conveyancing::factory()->create();
        $advocate = Advocate::factory()->create();

        $conveyancingAdvocate = ConveyancingAdvocate::factory()->create([
            'conveyancing_id' => $conveyancing->id,
            'advocate_id' => $advocate->id,
            'role' => 'lead',
        ]);

        $this->assertDatabaseHas('conveyancing_advocate', [
            'id' => $conveyancingAdvocate->id,
            'role' => 'lead',
        ]);
    }

    #[Test]
    public function it_belongs_to_an_advocate()
    {
        $advocate = Advocate::factory()->create();
        $conveyancingAdvocate = ConveyancingAdvocate::factory()->create([
            'advocate_id' => $advocate->id,
        ]);

        $this->assertTrue($conveyancingAdvocate->advocate->is($advocate));
    }

    #[Test]
    public function it_belongs_to_a_conveyancing()
    {
        $conveyancing = Conveyancing::factory()->create();
        $conveyancingAdvocate = ConveyancingAdvocate::factory()->create([
            'conveyancing_id' => $conveyancing->id,
        ]);

        $this->assertTrue($conveyancingAdvocate->conveyancing->is($conveyancing));
    }

    #[Test]
    public function it_can_soft_delete_a_conveyancing_advocate()
    {
        $conveyancingAdvocate = ConveyancingAdvocate::factory()->create();
        $conveyancingAdvocate->delete();

        $this->assertSoftDeleted('conveyancing_advocate', [
            'id' => $conveyancingAdvocate->id,
        ]);
    }
}
