<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\User;
use App\Models\Advocate;
use App\Models\LitigationAdvocate;
use Illuminate\Foundation\Testing\RefreshDatabase;
use PHPUnit\Framework\Attributes\Test;

class AdvocateTest extends TestCase
{
    use RefreshDatabase;

    #[Test]
    public function it_can_create_an_advocate()
    {
        $advocate = Advocate::factory()->create();

        $this->assertDatabaseHas('advocates', [
            'id'             => $advocate->id,
            'license_number' => $advocate->license_number,
        ]);
    }

    #[Test]
    public function it_can_update_an_advocate()
    {
        $advocate = Advocate::factory()->create([
            'specialization' => 'Civil',
        ]);

        $advocate->update([
            'specialization' => 'Corporate',
        ]);

        $this->assertDatabaseHas('advocates', [
            'id'             => $advocate->id,
            'specialization' => 'Corporate',
        ]);
    }

    #[Test]
    public function it_can_soft_delete_an_advocate()
    {
        $advocate = Advocate::factory()->create();

        $advocate->delete();

        $this->assertSoftDeleted('advocates', [
            'id' => $advocate->id,
        ]);
    }

    #[Test]
    public function an_advocate_belongs_to_a_user()
    {
        $user = User::factory()->create();
        $advocate = Advocate::factory()->create([
            'user_id' => $user->id,
        ]);

        $this->assertInstanceOf(User::class, $advocate->user);
        $this->assertEquals($user->id, $advocate->user->id);
    }

}
