<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\Account;
use Illuminate\Foundation\Testing\RefreshDatabase;
use PHPUnit\Framework\Attributes\Test;

class AccountTest extends TestCase{
    use RefreshDatabase;

    //Test to delete an account
    #[Test]
    public function it_can_create_an_account(){
        $account = Account::factory()->create();

        $this->assertDatabaseHas('accounts',[
            'id'=>$account->id,
            'name'=>$account->name,
            'number'=>$account->number
        ]);
    }

    //Test to soft delete an account
    #[Test]
    public function it_can_soft_delete_an_account(){
        $account = Account::factory()->create();

        $account->delete();

        $this->assertSoftDeleted('accounts',[
            'id'=>$account->id,
        ]);
    }

    //Test to retrieve an account
    #[Test]
    public function it_can_get_an_account(){
        $account = Account::factory()->create([
             'name' => 'Test Account',
             'number' => '1234567890',
        ]);

        $found = Account::find($account->id);
        $this->assertNotNull($found);
        $this->assertEquals('Test Account',$found->name);
        $this->assertEquals('1234567890',$found->number);
    }

    //Tests to update an account
    #[Test]
    public function it_can_update_an_account(){
        $account = Account::factory()->create([
            'name' => 'Old Name',
            'number' => '111111111',
        ]);

        $account->update([
            'name' => 'New Name',
            'number' => '222222222'
        ]);

        $this->assertDatabaseHas('accounts',[
            'id' => $account->id,
            'name' => 'New Name',
            'number' => '222222222'
        ]);
    }

    //Test to retrieve all accounts
    #[Test]
    public function it_can_get_all_accounts(){
        //3 accounts to be created
        $accounts = Account::factory()->count(3)->create();

        //fetch all accounts
        $allAccounts = Account::all();

        //assert we got exactly 3 records
        $this->assertCount(3,$allAccounts);

        //Assert each created account exists in the collection
        foreach($accounts as $account){
            $this->assertTrue($allAccounts->contains($account));
        }
    }
}