<div class="overflow-x-auto">

    <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">Case</th>
                <th class="border border-gray-200 px-4 py-2">Date</th>
                <th class="border border-gray-200 px-4 py-2">Amount Paid</th>
                <th class="border border-gray-200 px-4 py-2">Payment Method</th>
                <th class="border border-gray-200 px-4 py-2">Status</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="border border-gray-200 px-4 py-2">
                        <?php echo e($payment->litigation->case_number ?? 'N/A'); ?>

                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        <?php echo e(\Carbon\Carbon::parse($payment->created_at)->format('M d, Y')); ?>

                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        Ksh <?php echo e(number_format($payment->amount_paid, 2)); ?>

                    </td>
                    <td class="border border-gray-200 px-4 py-2">
                        <?php echo e(ucfirst($payment->payment_method)); ?>

                    </td>
                    <td class="border border-gray-200 px-4 py-2 dark:text-gray-300">
                        <?php if (isset($component)) { $__componentOriginal986dce9114ddce94a270ab00ce6c273d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal986dce9114ddce94a270ab00ce6c273d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.badge','data' => ['color' => match (strtolower($payment->status)) {
                            'completed' => 'success',
                            'failed' => 'danger',
                            'pending' => 'warning',
                            default => 'gray',
                        }]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('filament::badge'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(match (strtolower($payment->status)) {
                            'completed' => 'success',
                            'failed' => 'danger',
                            'pending' => 'warning',
                            default => 'gray',
                        })]); ?>
                            <?php echo e(ucwords(str_replace('_', ' ', $payment->status))); ?>

                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal986dce9114ddce94a270ab00ce6c273d)): ?>
<?php $attributes = $__attributesOriginal986dce9114ddce94a270ab00ce6c273d; ?>
<?php unset($__attributesOriginal986dce9114ddce94a270ab00ce6c273d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal986dce9114ddce94a270ab00ce6c273d)): ?>
<?php $component = $__componentOriginal986dce9114ddce94a270ab00ce6c273d; ?>
<?php unset($__componentOriginal986dce9114ddce94a270ab00ce6c273d); ?>
<?php endif; ?>
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="border border-gray-200 px-4 py-2 text-center text-gray-500">
                        No payments found.
                    </td>
                </tr>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </tbody>

        <!--[if BLOCK]><![endif]--><?php if($payments->count()): ?>
            <tfoot>
                <tr class="bg-gray-100 dark:bg-gray-900/30 font-semibold">
                    <td colspan="2" class="border border-gray-200 px-4 py-2 text-right">Total Paid:</td>
                    <td colspan="3" class="border border-gray-200 px-4 py-2 text-left">
                        Ksh <?php echo e(number_format($total, 2)); ?>

                    </td>
                </tr>
            </tfoot>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </table>
</div><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/client-components/client-litigation-payments-table.blade.php ENDPATH**/ ?>