<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Client Financial Report</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        h1, h2 { color: #1a3c6e; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 40px; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .section { margin-bottom: 50px; }
        .header { text-align: center; margin-bottom: 30px; }
        .total-row { font-weight: bold; background-color: #e6f3ff; }
        .balance-row { font-weight: bold; background-color: #f0f8ff; }
    </style>
</head>
<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    
    <div class="header">
        <h1>Client Financial Report</h1>
        <h2><?php echo e($client->user->name ?? 'Client'); ?> (ID: <?php echo e($client->id); ?>)</h2>
    </div>

    <!-- Conveyancing Payments Section -->
    <?php if($conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0 ||
        $conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0 ||
        $conveyancingPayments->where('paid_by', '!=', $client->id)->count() > 0): ?>
        <div class="section">
            <h2>Conveyancing Payments</h2>

            <!-- Purchase Price Paid to Owner -->
            <?php if($conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0): ?>
                <h3>Purchase Price Paid to Owner</h3>
                <?php $__currentLoopData = $conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->groupBy('conveyancing_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conveyancingId => $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $conveyancing = $payments->first()->conveyancing;
                        $salePrice = $conveyancing->sale_price ?? 0;
                        $totalPaid = $payments->sum('amount_paid');
                        $balance = ($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id) ? $salePrice - $totalPaid : 0;
                    ?>
                    <h4><?php echo e($conveyancing->property_address ?? 'Conveyancing'); ?> (Serial: <?php echo e($conveyancing->serial_number ?? 'N/A'); ?>) - Owner: <?php echo e($conveyancing->client->user->name ?? 'N/A'); ?></h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Property Address</th>
                                <th>Owner</th>
                                <th>Amount Paid</th>
                                <th>Paid By</th>
                                <th>Transaction ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($payment->conveyancing->serial_number ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->conveyancing->property_address ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->conveyancing->client->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                                    <td><?php echo e($payment->paidBy->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->transaction_id); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="total-row">
                                <td colspan="3">Total</td>
                                <td><?php echo e(number_format($totalPaid, 2)); ?></td>
                                <td colspan="2"></td>
                            </tr>
                            <?php if($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id): ?>
                                <tr class="balance-row">
                                    <td colspan="3">Balance (Sale Price: <?php echo e(number_format($salePrice, 2)); ?>)</td>
                                    <td><?php echo e(number_format($balance, 2)); ?></td>
                                    <td colspan="2"></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <!-- Payments Made -->
            <?php if($conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0): ?>
                <h3>Payments Made</h3>
                <?php $__currentLoopData = $conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->groupBy('conveyancing_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conveyancingId => $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $conveyancing = $payments->first()->conveyancing;
                        $agreedFees = $client->id == $conveyancing->buyer_id ? ($conveyancing->buyer_legal_fees ?? 0) : ($conveyancing->seller_legal_fees ?? 0);
                        $totalPaid = $payments->sum('amount_paid');
                        $balance = $agreedFees - $totalPaid;
                    ?>
                    <h4><?php echo e($conveyancing->property_address ?? 'Conveyancing'); ?> (Serial: <?php echo e($conveyancing->serial_number ?? 'N/A'); ?>) - Owner: <?php echo e($conveyancing->client->user->name ?? 'N/A'); ?></h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Property Address</th>
                                <th>Owner</th>
                                <th>Amount Paid</th>
                                <th>Paid By</th>
                                <th>Payment Type</th>
                                <th>Transaction ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($payment->conveyancing->serial_number ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->conveyancing->property_address ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->conveyancing->client->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                                    <td><?php echo e($payment->paidBy->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->type == 'legal_fees' ? 'Legal Fees' : 'Purchase Price'); ?></td>
                                    <td><?php echo e($payment->transaction_id); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="total-row">
                                <td colspan="3">Total</td>
                                <td><?php echo e(number_format($totalPaid, 2)); ?></td>
                                <td colspan="3"></td>
                            </tr>
                            <tr class="balance-row">
                                <td colspan="3">Balance (Agreed Legal Fees: <?php echo e(number_format($agreedFees, 2)); ?>)</td>
                                <td><?php echo e(number_format($balance, 2)); ?></td>
                                <td colspan="3"></td>
                            </tr>
                        </tbody>
                    </table>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <!-- Purchase Price Received -->
            <?php if($conveyancingPayments->where('paid_by', '!=', $client->id)->count() > 0): ?>
                <h3>Purchase Price Received</h3>
                <?php $__currentLoopData = $conveyancingPayments->where('paid_by', '!=', $client->id)->groupBy('conveyancing_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conveyancingId => $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $conveyancing = $payments->first()->conveyancing;
                        $salePrice = $conveyancing->sale_price ?? 0;
                        $totalReceived = $payments->sum('amount_paid');
                        $balance = ($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id) ? $salePrice - $totalReceived : 0;
                    ?>
                    <h4><?php echo e($conveyancing->property_address ?? 'Conveyancing'); ?> (Serial: <?php echo e($conveyancing->serial_number ?? 'N/A'); ?>) - Owner: <?php echo e($conveyancing->client->user->name ?? 'N/A'); ?></h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Paid To</th>
                                <th>Amount Received</th>
                                <th>Paid By</th>
                                <th>Payment Method</th>
                                <th>Transaction ID</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($payment->client->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                                    <td><?php echo e($payment->paidBy->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($payment->payment_method); ?></td>
                                    <td><?php echo e($payment->transaction_id); ?></td>
                                    <td><?php echo e($payment->created_at->format('F j, Y')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="total-row">
                                <td colspan="1">Total</td>
                                <td><?php echo e(number_format($totalReceived, 2)); ?></td>
                                <td colspan="4"></td>
                            </tr>
                            <?php if($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id): ?>
                                <tr class="balance-row">
                                    <td colspan="1">Balance (Sale Price: <?php echo e(number_format($salePrice, 2)); ?>)</td>
                                    <td><?php echo e(number_format($balance, 2)); ?></td>
                                    <td colspan="4"></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Litigation Payments Section -->
    <?php if($litigationPayments->count() > 0): ?>
        <div class="section">
            <h2>Litigation Payments</h2>
            <?php $__currentLoopData = $litigationPayments->groupBy('litigation_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $litigationId => $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <h4><?php echo e($payments->first()->litigation->name ?? 'Litigation'); ?> (Case Number: <?php echo e($payments->first()->litigation->case_number ?? 'N/A'); ?>)</h4>
                <table>
                    <thead>
                        <tr>
                            <th>Case Number</th>
                            <th>Litigation Name</th>
                            <th>Amount Paid</th>
                            <th>Transaction ID</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($payment->litigation->case_number ?? 'N/A'); ?></td>
                                <td><?php echo e($payment->litigation->description ?? 'N/A'); ?></td>
                                <td><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                                <td><?php echo e($payment->transaction_id); ?></td>
                                <td><?php echo e($payment->created_at->format('F j, Y')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="total-row">
                            <td colspan="2">Total</td>
                            <td><?php echo e(number_format($payments->sum('amount_paid'), 2)); ?></td>
                            <td colspan="2"></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <!-- Project Client Payments Section -->
    <?php if($projectClientPayments->count() > 0): ?>
        <div class="section">
            <h2>Project Client Payments</h2>
            <?php $__currentLoopData = $projectClientPayments->groupBy('projectClient.project.id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectId => $payments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <h4><?php echo e($payments->first()->projectClient->project->name ?? 'Unknown Project'); ?> (ID: <?php echo e($projectId ?? 'N/A'); ?>)</h4>
                <table>
                    <thead>
                        <tr> 
                            <th>Project Name</th>
                            <th>Amount Paid</th>
                            <th>Payment Method</th>
                            <th>Transaction ID</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($payment->projectClient->project->name ?? 'N/A'); ?></td>
                                <td><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                                <td><?php echo e($payment->payment_method ?? 'N/A'); ?></td>
                                <td><?php echo e($payment->transaction_id ?? 'N/A'); ?></td>
                                <td><?php echo e($payment->created_at ? $payment->created_at->format('F j, Y') : 'N/A'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="total-row">
                            <td colspan="2">Total</td>
                            <td><?php echo e(number_format($payments->sum('amount_paid'), 2)); ?></td>
                            <td colspan="3"></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <!-- No Data Message -->
    <?php if($conveyancingPayments->count() == 0 && $litigationPayments->count() == 0 && $projectClientPayments->count() == 0): ?>
        <p>No report for the user <?php echo e($client->user->name ?? 'Client'); ?>.</p>
    <?php endif; ?>
</body>
</html><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/client.blade.php ENDPATH**/ ?>