<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Conveyancing Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;

        }

        .payments-table,
        .advocates-table {
            text-align: center;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
        }

        th {
            background: #eee;
        }

        h2 {
            margin-top: 30px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    <h1>Conveyancing Details</h1>

    <h2>Transaction Info</h2>
    <table>
        <tr>
            <th>Referrence Number</th>
            <td><?php echo e($record->serial_number ?? 'N/A'); ?></td>
        </tr>
        <tr>
            <th>Property Details</th>
            <td><?php echo e($record->property_address); ?></td>
        </tr>
        <tr>
            <th>Sale Price</th>
            <td><?php echo e(number_format($record->sale_price, 2)); ?></td>
        </tr>

        <tr>
            <th>Contract Date</th>
            <td><?php echo e($record->contract_date ? \Carbon\Carbon::parse($record->contract_date)->format('F j, Y') : ''); ?></td>
        </tr>
        <tr>
            <th>Completion Period</th>
            <td><?php echo e($record->completion_period ? \Carbon\Carbon::parse($record->settlement_date)->format('F j, Y') : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Notes</th>
            <td><?php echo e($record->notes); ?></td>
        </tr>
    </table>

    <?php if($client): ?>
        <h2>Client</h2>
        <table>
            <tr>
                <th>Name</th>
                <td><?php echo e($client->user->name ?? ''); ?></td>
            </tr>
            <tr>
                <th>Email</th>
                <td><?php echo e($client->user->email ?? ''); ?></td>
            </tr>
            <tr>
                <th>Phone</th>
                <td><?php echo e($client->phone); ?></td>
            </tr>
            <tr>
                <th>National ID</th>
                <td><?php echo e($client->national_id); ?></td>
            </tr>
            <tr>
                <th>Address</th>
                <td><?php echo e($client->address); ?></td>
            </tr>
        </table>
    <?php endif; ?>

    <?php if($record->buyer || $record->seller): ?>
        <h2>Parties</h2>
        <table>
            <tr>
                <th>Buyer Name</th>
                <td><?php echo e($record->buyer?->user?->name ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Seller Name</th>
                <td><?php echo e($record->seller?->user?->name ?? 'N/A'); ?></td>
            </tr>
        </table>
    <?php endif; ?>


    <?php if($advocates->isNotEmpty()): ?>
        
        <h2>Advocates</h2>
        <table class="advocates-table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Role</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $advocates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advocate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($advocate->advocate->user->name ?? ''); ?></td>
                        <td><?php echo e($advocate->role); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>
    <?php if($expenses->count()): ?>
        <h2>Expenses</h2>
        <table class="payments-table">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Amount (KES)</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($expense->expenseItem->expense_item ?? 'Other'); ?></td>
                        <td><?php echo e(number_format($expense->amount_paid, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="background:#eee; font-weight:bold;">
                    <td>Total Expenses</td>
                    <td><?php echo e(number_format($expenses->sum('amount_paid'), 2)); ?></td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>


</body>

</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/conveyancing.blade.php ENDPATH**/ ?>