<div class="overflow-x-auto">
    <table class="w-full text-sm table-auto border dark:border-gray-700">
        <tbody>
            <tr class="text-xs uppercase bg-gray-100 dark:bg-gray-800 dark:text-gray-400">
                <td class="px-4 py-2 font-semibold border">Quote Number</td>
                <td class="px-4 py-2 border"><?php echo e($quotation->quote_number); ?></td>
            </tr>
            <tr>
                <td class="px-4 py-2 font-semibold border">Client</td>
                <td class="px-4 py-2 border"><?php echo e($quotation->client->user->name ?? '-'); ?></td>
            </tr>
            <tr>
                <td class="px-4 py-2 font-semibold border">Type</td>
                <td class="px-4 py-2 border"><?php echo e(ucfirst($quotation->type)); ?></td>
            </tr>
            <tr>
                <td class="px-4 py-2 font-semibold border">Amount</td>
                <td class="px-4 py-2 border">KSh <?php echo e(number_format($quotation->amount, 2)); ?></td>
            </tr>
            <tr>
                <td class="px-4 py-2 font-semibold border">Quote Date</td>
                <td class="px-4 py-2 border"><?php echo e(\Carbon\Carbon::parse($quotation->quote_date)->format('M d, Y')); ?></td>
            </tr>
            <tr>
                <td class="px-4 py-2 font-semibold border">Details</td>
                <td class="px-4 py-2 border"><?php echo e($quotation->details); ?></td>
            </tr>
        </tbody>
    </table>
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/quotation-components/quotation-details.blade.php ENDPATH**/ ?>