<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Details - <?php echo e($project->name); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 7px; color: #333; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { border: 1px solid #ccc; padding: 6px 8px; text-align: left; vertical-align: top; }
        th { background-color: #f2f2f2; }
        h2, h3 { margin-bottom: 10px; }
        .section { margin-bottom: 40px; }
        .total-row { font-weight: bold; background-color: #f9f9f9; }
    </style>
</head>
<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    
    <div class="section">
        <h2>Project Information</h2>
        <table>
            <tr><th>Name</th><td><?php echo e($project->name ?? 'N/A'); ?></td></tr>
            <tr><th>Location</th><td><?php echo e($project->location ?? 'N/A'); ?></td></tr>
            <tr><th>Type</th><td><?php echo e(ucfirst(str_replace('_', ' ', $project->type)) ?? 'N/A'); ?></td></tr>
            <tr><th>Number of Units</th><td><?php echo e($project->number_of_units ?? 'N/A'); ?></td></tr>
            <tr><th>Description</th><td><?php echo e($project->description ?? 'N/A'); ?></td></tr>
        </table>
    </div>

    
    <div class="section">
        <h2>Clients</h2>
        <?php if($project->projectClients->isNotEmpty()): ?>
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Client Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Nationality</th>
                        <th>KRA Pin</th>
                        <th>Passport Details</th>
                        <th>Apartment/Subdivision</th>
                        <th>Amount Charged  (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $project->projectClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($client->client->user->name ?? 'N/A'); ?></td>
                            <td><?php echo e($client->client->national_id ?? 'N/A'); ?></td>
                            <td><?php echo e($client->client->phone ?? 'N/A'); ?></td>
                            <td><?php echo e($client->client->nationality ?? 'N/A'); ?></td>
                            <td><?php echo e($client->client->kra_pin ?? 'N/A'); ?></td>
                            <td>
                                <strong>#:</strong> <?php echo e($client->client->passport_number ?? 'N/A'); ?>, 
                                <strong>:</strong> <?php echo e($client->client->passport_expiry_date ?? 'N/A'); ?>

                            </td>
                            <?php
                                $apartment = $client->apartmentDetail;
                                $subdivision = $client->subdivisionDetail;
                            ?>
                            <?php if($apartment): ?>
                                <td>
                                    <strong>Floor:</strong> <?php echo e($apartment->floor ?? 'N/A'); ?>, 
                                    <strong>Unit:</strong> <?php echo e($apartment->flat_name ?? 'N/A'); ?>, 
                                    <strong>Type:</strong> <?php echo e($apartment->unit_type ?? 'N/A'); ?>

                                </td>
                                <td><?php echo e(number_format($apartment->amount_charged  ?? 0, 2)); ?></td>
                            <?php elseif($subdivision): ?>
                                <td>
                                    <strong>Plot:</strong> <?php echo e($subdivision->plot_number ?? 'N/A'); ?>, 
                                    <strong>Size:</strong> <?php echo e($subdivision->size ?? 'N/A'); ?>

                                </td>
                                <td><?php echo e(number_format($subdivision->amount_charged ?? 0, 2)); ?></td>
                                
                            <?php else: ?>
                                <td>No apartment or subdivision info</td>
                                <td>0.00</td>
                                <td>0.00</td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="8">Total</td>
                        <td><?php echo e(number_format($totalAmountCharged, 2)); ?></td>
                    </tr>
                </tfoot>
            </table>
        <?php else: ?>
            <p>No clients assigned.</p>
        <?php endif; ?>
    </div>

</body>
</html><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/project.blade.php ENDPATH**/ ?>