<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Expense #<?php echo e($expense->id); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 14px;
            line-height: 1.6;
            margin: 0;
            padding: 40px;
            background-color: #f9fafb;
            color: #1f2937;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 30px;
            border: 1px solid #e5e7eb;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 20px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
            color: #111827;
            font-weight: 700;
        }

        .header p {
            margin: 8px 0;
            font-size: 14px;
            color: #4b5563;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }

        th {
            background-color: #f3f4f6;
            font-weight: 600;
            color: #374151;
            text-transform: uppercase;
            font-size: 12px;
        }

        td {
            color: #1f2937;
        }

        .summary {
            margin-top: 40px;
            font-size: 16px;
            font-weight: 600;
            color: #dc2626;
            text-align: center;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
            border-top: 1px solid #e5e7eb;
            padding-top: 20px;
        }
    </style>
</head>

<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>

    <div class="container">
        <div class="header">
            <h2>Expense Record</h2>
            <p>Expense ID: #<?php echo e($expense->id); ?></p>
            <p>Date: <?php echo e($expense->created_at->format('d M Y, h:i A')); ?></p>
        </div>

        <table>
            <tr>
                <td class="px-4 py-2 border font-medium">Expense Item</td>
                <td class="px-4 py-2 border">
                    <?php echo e($expense->expenseItem->expense_item ?? '—'); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Amount Paid</td>
                <td class="px-4 py-2 border">
                    KES <?php echo e(number_format($expense->amount_paid, 2)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Balance</td>
                <td class="px-4 py-2 border">
                    KES <?php echo e(number_format($expense->balance, 2)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Payment Method</td>
                <td class="px-4 py-2 border">
                    <?php echo e(ucfirst($expense->payment_method)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Status</td>
                <td class="px-4 py-2 border">
                    <?php echo e(ucfirst($expense->status)); ?>

                </td>
            </tr>

             <tr>
                <td class="px-4 py-2 border font-medium">Expensable Type</td>
                <td class="px-4 py-2 border">
                    <?php echo e(class_basename($expense->expensable_type)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Related To</td>
                <td class="px-4 py-2 border">
                    <?php
                        $expensable = $expense->expensable;
                    ?>

                    <?php if($expensable): ?>
                        <?php switch(class_basename($expensable)):
                            case ('Conveyancing'): ?>
                                Conveyancing – <?php echo e($expensable->serial_number ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php case ('Litigation'): ?>
                                Litigation – <?php echo e($expensable->case_number ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php case ('Project'): ?>
                                Project – <?php echo e($expensable->name ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php default: ?>
                                <?php echo e(class_basename($expensable)); ?> – #<?php echo e($expensable->id); ?>

                        <?php endswitch; ?>
                    <?php else: ?>
                        <span class="text-gray-500 italic">No associated record</span>
                    <?php endif; ?>
                </td>
            </tr>

        </table>

        <div class="summary">
            This expense has been logged successfully.
        </div>

        <div class="footer">
            © <?php echo e(now()->year); ?> Abdullahi Yusuf & Company. All rights reserved.
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/expense.blade.php ENDPATH**/ ?>