<div class="overflow-x-auto rounded-md shadow-md border border-gray-200 dark:border-gray-700">
<table class="w-full min-w-full text-center mt-6">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Invoice No</th>
            <th class="border border-gray-200 px-4 py-2">Client</th>
            <th class="border border-gray-200 px-4 py-2">Status</th>
            <th class="border border-gray-200 px-4 py-2">Amount (KES)</th>
            <th class="border border-gray-200 px-4 py-2">Reference</th>
        </tr>
    </thead>

    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        <?php $invoice = $invoice ?? ($invoices ?? null); ?>

        <!--[if BLOCK]><![endif]--><?php if($invoice): ?>
            <tr>
                <td class="border border-gray-200 px-4 py-2"><?php echo e($invoice->invoice_number); ?></td>
                <td class="border border-gray-200 px-4 py-2"><?php echo e($invoice->client?->user?->name ?? 'N/A'); ?></td>
                <td class="border border-gray-200 px-4 py-2 capitalize"><?php echo e($invoice->status); ?></td>
                <td class="border border-gray-200 px-4 py-2"><?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                <td class="border border-gray-200 px-4 py-2">
                    <!--[if BLOCK]><![endif]--><?php if($invoice->payable_type === \App\Models\Conveyancing::class): ?>
                        <?php echo e($invoice->payable?->serial_number ?? 'N/A'); ?>

                    <?php elseif($invoice->payable_type === \App\Models\Litigation::class): ?>
                        <?php echo e($invoice->payable?->case_number ?? 'N/A'); ?>

                    <?php elseif($invoice->payable_type === \App\Models\Project::class): ?>
                        <?php echo e($invoice->payable?->name ?? 'N/A'); ?>

                    <?php else: ?>
                        <?php echo e($invoice->payable_id ?? 'N/A'); ?>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
            </tr>
        <?php else: ?>
            <tr>
                <td colspan="7" class="text-center py-4 text-gray-500">No invoice data found.</td>
            </tr>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </tbody>
</table>
</div><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/invoice-components/invoice-details.blade.php ENDPATH**/ ?>