<!-- resources/views/infolists/project-components/project-clients-table.blade.php -->
<?php $__env->startPush('styles'); ?>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 5px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        h2,
        h3 {
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 40px;
        }

        .pdf-icon {
            width: 20px;
            height: 20px;
            vertical-align: middle;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php
    // Use projectClients if passed, otherwise fall back to projectRecord->projectClients
    $clients = $projectClients ?? ($projectRecord->projectClients ?? collect());
?>

<div class="p-4">
    <!--[if BLOCK]><![endif]--><?php if($clients->isEmpty()): ?>
        <p class="text-gray-500 dark:text-gray-400">No clients found for this project.</p>
    <?php else: ?>
        <!-- Clients Table -->
        <div class="overflow-x-auto">
            <table class="w-full min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">#</th> 
                        <th>Client Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>KRA Pin</th>
                        <th>Apartment/Subdivision</th>
                        <th>Amount Charged</th>
                        <th>Document</th>
                        <th>Project Cient Report</th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-t dark:border-gray-600">
                            <td class="px-4 py-2"><?php echo e($loop->iteration); ?></td> 
                            <td class="px-4 py-2">

                                <a href="<?php echo e(route('filament.admin.resources.clients.view', $projectClient->client->id)); ?>"
                                    class="text-blue-600 hover:underline">
                                    <?php echo e($projectClient->client->user->name ?? 'N/A'); ?>

                                </a>
                            </td>
                            <td class="px-4 py-2"><?php echo e($projectClient->client->national_id ?? 'N/A'); ?></td>
                            <td class="px-4 py-2"><?php echo e($projectClient->client->phone ?? 'N/A'); ?></td>
                            <td class="px-4 py-2"><?php echo e($projectClient->client->kra_pin); ?></td>
                            <?php
                                $apartment = $projectClient->apartmentDetail;
                                $subdivision = $projectClient->subdivisionDetail;
                                $documents = $projectClient->documents;
                            ?>
                            <!--[if BLOCK]><![endif]--><?php if($apartment): ?>
                                <td>
                                    <strong> Floor : </strong> <?php echo e($apartment->floor ?? 'N/A'); ?>,
                                    <strong> Unit : </strong> <?php echo e($apartment->flat_name ?? 'N/A'); ?>,
                                    <strong> Type : </strong> <?php echo e($apartment->unit_type ?? 'N/A'); ?>

                                </td>
                                <td><?php echo e(number_format($apartment->amount_charged ?? 0, 2)); ?></td>
                            <?php elseif($subdivision): ?>
                                <td>
                                    <strong> Plot : </strong> <?php echo e($subdivision->plot_number ?? 'N/A'); ?>,
                                    <strong> Size : </strong> <?php echo e($subdivision->size ?? 'N/A'); ?> ,
                                </td>
                                <td><?php echo e(number_format($subdivision->amount_charged ?? 0, 2)); ?></td>
                            <?php else: ?>
                                <td colspan="3">No apartment or subdivision info</td>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($documents && $documents->isNotEmpty()): ?>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-2">
                                            <a href="<?php echo e(asset('storage/' . $document->file_path)); ?>" target="_blank"
                                                class="flex items-center">
                                                <img src="<?php echo e(asset('images/pdf-icon.png')); ?>" alt="PDF"
                                                    class="pdf-icon">
                                            </a>
                                            <p><?php echo e($document->name); ?></p>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php else: ?>
                                    N/A
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>


                            <td class="px-4 py-2">
                                <a href="<?php echo e(route('filament.resources.projects.client-pdf', ['record' => $projectRecord->id, 'projectClient' => $projectClient->id])); ?>"
                                    target="_blank"
                                    class="inline-flex items-center px-3 py-1 text-sm font-medium rounded-lg bg-primary-600 text-white hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                    
                                    Download 
                                </a>
                            </td>


                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/project-components/project-clients-table.blade.php ENDPATH**/ ?>