<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Litigation Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            text-align: center;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
        }

        th {
            background: #eee;
        }

        h2 {
            margin-top: 30px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>

    <h1>Litigation Details</h1>
    
    <h2>Case Info</h2>
    <table>
        <tr>
            <th>Case Number</th>
            <td><?php echo e($litigation->case_number); ?></td>
        </tr>
        <tr>
            <th>Court Assigned Case Number</th>
            <td><?php echo e($litigation->court_assigned_case_number); ?></td>
        </tr>
        <tr>
            <th>Type</th>
            <td><?php echo e(ucwords(str_replace('_', ' ', $litigation->litigationCaseType->name))); ?></td>
        </tr>
        
        <tr>
            <th>Description</th>
            <td><?php echo e($litigation->description); ?></td>
        </tr>
        <tr>
            <th>Case Category</th>
            <td><?php echo e($litigation->litigationCategory->name); ?></td>
        </tr>
        <tr>
            <th>Station</th>
            <td><?php echo e($litigation->station); ?></td>
        </tr>
        <tr>
            <th>Filing Date</th>
            <td><?php echo e(\Carbon\Carbon::parse($litigation->filing_date)->format('jS F, Y')); ?></td>
        </tr>
    </table>


    
    <?php if(!empty($client)): ?>
        <h2>Client</h2>
        <table>
            <tr>
                <th>Name</th>
                <td><?php echo e($litigation->client->user->name ?? ''); ?></td>
            </tr>
            <tr>
                <th>Email</th>
                <td><?php echo e($litigation->client->user->email ?? ''); ?></td>
            </tr>
            <tr>
                <th>Phone</th>
                <td><?php echo e($litigation->client->phone); ?></td>
            </tr>
        </table>
    <?php endif; ?>

    
    <?php if($parties->isNotEmpty()): ?>
        <h2>Parties</h2>
        <table>
            <thead>
                <tr>
                    <th>Party</th>
                    <th>Party Type</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Gender</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $parties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $party): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($party->party); ?></td>
                        <td><?php echo e(ucwords(str_replace('_', ' ', $party->party_type))); ?></td>
                        <td><?php echo e($party->email); ?></td>
                        <td><?php echo e($party->phone); ?></td>
                        <td><?php echo e(ucfirst($party->gender)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>


    
    <?php if($litigation->litigationActivities && $litigation->litigationActivities->isNotEmpty()): ?>
        <h2>Litigation Activities</h2>
        <table>
            <thead>
                <tr>
                    <th>Activity</th>
                    <th>Date</th>
                    <th>Court Room</th>
                    <th>Outcome</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $litigation->litigationActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($activity->activity); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($activity->activity_date)->format('F j, Y')); ?></td>
                        <td><?php echo e($activity->court_room); ?></td>
                        <td><?php echo e($activity->outcome); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>



    
</body>

</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/litigation.blade.php ENDPATH**/ ?>