<div class="overflow-x-auto">
    <table class="w-full min-w-full border text-center border-gray-300 divide-y divide-gray-200 text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="border border-gray-200 px-4 py-2">#</th>
                <th class="border border-gray-200 px-4 py-2">Project Name</th>
                <th class="border border-gray-200 px-4 py-2">Type</th>
                <th class="border border-gray-200 px-4 py-2">Room/Plot Type</th>
                <th class="border border-gray-200 px-4 py-2">Project Cient Report</th>
            </tr>
        </thead>
        <tbody>
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $projectClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectClient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="divide-x divide-gray-200">
                    
                    <td class="px-4 py-2"><?php echo e($loop->iteration); ?></td>

                    
                    <td class="px-4 py-2">
                        <?php echo e($projectClient->project->name ?? 'N/A'); ?>

                    </td>

                    
                    <td class="px-4 py-2">
                        <?php echo e(ucfirst($projectClient->project->type ?? 'N/A')); ?>

                    </td>

                    
                    <td class="px-4 py-2">
                        <!--[if BLOCK]><![endif]--><?php if($projectClient->project->type === 'apartment'): ?>
                            Floor - <?php echo e($projectClient->apartmentDetail->floor ?? 'N/A'); ?>,
                            Hse - <?php echo e($projectClient->apartmentDetail->flat_name ?? 'N/A'); ?>

                        <?php elseif($projectClient->project->type === 'subdivision'): ?>
                            <?php echo e($projectClient->subdivisionDetail->plot_type ?? 'N/A'); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </td>

                    
                    <td class="px-4 py-2">
                        <a href="<?php echo e(route('filament.resources.projects.client-pdf', ['record' => $projectClient->project->id, 'projectClient' => $projectClient->id])); ?>"
                            target="_blank"
                            class="inline-flex items-center px-3 py-1 text-sm font-medium rounded-lg bg-primary-600 text-white hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                            Download 
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="px-4 py-2 text-center text-gray-500">
                        No projects found.
                    </td>
                </tr>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </tbody>
    </table>
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/client-components/client-projects-table.blade.php ENDPATH**/ ?>