<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['payment']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['payment']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Official Receipt #<?php echo e($payment->id); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
       
        body {
            font-family: 'Times New Roman', serif;
            background: #ffffff;
            color: #000000;
            line-height: 1.4;
            padding: 20px;
        }
       
        .receipt-container {
            max-width: 210mm;
            margin: 0 auto;
            background: #ffffff;
            border: 2px solid #000000;
            position: relative;
        }
       
        .receipt-header {
            text-align: center;
            padding: 30px;
            border-bottom: 3px double #000000;
            background: #ffffff;
        }
       
        .company-name {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
       
        .company-details {
            font-size: 12px;
            margin-bottom: 20px;
            line-height: 1.3;
        }
       
        .receipt-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
            text-decoration: underline;
        }
       
        .receipt-number {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
        }
       
        .receipt-date {
            font-size: 14px;
        }
       
        .status-stamp {
            position: absolute;
            top: 20px;
            right: 20px;
            border: 3px solid #008000;
            color: #008000;
            padding: 10px 20px;
            font-weight: bold;
            text-transform: uppercase;
            transform: rotate(15deg);
            font-size: 14px;
        }
       
        .receipt-body {
            padding: 30px;
        }
       
        .section {
            margin-bottom: 25px;
        }
       
        .section-title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 15px;
            text-transform: uppercase;
            border-bottom: 1px solid #000000;
            padding-bottom: 5px;
        }
       
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
       
        .details-table td {
            padding: 8px 12px;
            border: 1px solid #000000;
            vertical-align: top;
        }
       
        .details-table .label {
            background: #f5f5f5;
            font-weight: bold;
            width: 35%;
        }
       
        .details-table .value {
            width: 65%;
        }
       
        .amount-section {
            border: 3px double #000000;
            padding: 20px;
            text-align: center;
            margin: 25px 0;
            background: #f9f9f9;
        }
       
        .amount-label {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
       
        .amount-value {
            font-size: 32px;
            font-weight: bold;
            font-family: 'Courier New', monospace;
        }
       
        .amount-words {
            font-size: 14px;
            font-style: italic;
            margin-top: 10px;
            text-transform: capitalize;
        }
       
        .entity-section {
            border: 1px solid #000000;
            padding: 15px;
            margin: 20px 0;
            background: #fafafa;
        }
       
        .entity-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
       
        .entity-details {
            font-size: 14px;
        }
       
        .receipt-footer {
            border-top: 3px double #000000;
            padding: 20px 30px;
            text-align: center;
            background: #f9f9f9;
        }
       
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin: 30px 0;
        }
       
        .signature-box {
            width: 200px;
            text-align: center;
        }
       
        .signature-line {
            border-bottom: 1px solid #000000;
            height: 50px;
            margin-bottom: 5px;
        }
       
        .signature-label {
            font-size: 12px;
            font-weight: bold;
        }
       
        .footer-text {
            font-size: 12px;
            margin: 10px 0;
        }
       
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 72px;
            color: rgba(0, 0, 0, 0.05);
            font-weight: bold;
            pointer-events: none;
            z-index: 1;
        }
       
        @media print {
            body {
                padding: 0;
            }
            .receipt-container {
                border: 2px solid #000000;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="watermark">OFFICIAL</div>
       
        <!-- Header Section -->
        <div class="receipt-header">
            <div class="company-name">AYC</div>
            <div class="company-details">
                P.O. Box [Number], [City], Kenya<br>
                Tel: [Phone] | Email: [Email]<br>
            </div>
           
            <div class="receipt-title">Official Receipt</div>
            <div class="receipt-number">Receipt No: <?php echo e(str_pad($payment->id, 6, '0', STR_PAD_LEFT)); ?></div>
            <div class="receipt-date">Date: <?php echo e($payment->created_at->format('F j, Y')); ?></div>
           
            <div class="status-stamp"><?php echo e(strtoupper($payment->status)); ?></div>
        </div>

        <!-- Body Section -->
        <div class="receipt-body">
           
            <!-- Transaction Details Section -->
            <div class="section">
                <div class="section-title">Transaction Information</div>
                <table class="details-table">
                    <tr>
                        <td class="label">Transaction Type</td>
                        <td class="value">
                            <?php echo e($payment->direction === 'incoming' ? 'DEPOSIT RECEIVED' : 'PAYMENT MADE'); ?>

                        </td>
                    </tr>
                    <tr>
                        <td class="label">Service Category</td>
                        <td class="value"><?php echo e(str_replace('App\\Models\\', '', $payment->payable_type)); ?></td>
                    </tr>
                    <?php if($payment->transaction_id): ?>
                    <tr>
                        <td class="label">Transaction Reference</td>
                        <td class="value"><?php echo e($payment->transaction_id); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td class="label">Payment Method</td>
                        <td class="value">
                            <?php
                                $methodText = match($payment->payment_method) {
                                    'mpesa' => 'M-Pesa Mobile Money',
                                    'bank' => 'Bank Transfer',
                                    'cash' => 'Cash Payment',
                                    default => strtoupper($payment->payment_method ?? 'N/A')
                                };
                            ?>
                            <?php echo e($methodText); ?>

                        </td>
                    </tr>
                    <?php if($payment->account_id && $payment->payment_method === 'bank'): ?>
                    <tr>
                        <td class="label">Bank Account</td>
                        <td class="value"><?php echo e($payment->account->name); ?> - <?php echo e($payment->account->number); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td class="label">Processed By</td>
                        <td class="value"><?php echo e(auth()->user()->name ?? 'System Administrator'); ?></td>
                    </tr>
                </table>
            </div>

            <!-- Client Information (Only for Deposits) -->
            <?php if($payment->direction === 'incoming' && $payment->client_id): ?>
            <div class="section">
                <div class="section-title">Client Information</div>
                <table class="details-table">
                    <tr>
                        <td class="label">Client Name</td>
                        <td class="value"><?php echo e($payment->client?->user?->name ?? $payment->client?->phone ?? 'Client #' . $payment->client_id); ?></td>
                    </tr>
                    <?php if($payment->client?->user?->email): ?>
                    <tr>
                        <td class="label">Email</td>
                        <td class="value"><?php echo e($payment->client->user->email); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($payment->client?->phone): ?>
                    <tr>
                        <td class="label">Phone</td>
                        <td class="value"><?php echo e($payment->client->phone); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
            <?php endif; ?>

            <!-- Service Details Section -->
            <?php if($payment->payable): ?>
            <div class="section">
                <div class="section-title">Service Details</div>
                <div class="entity-section">
                    <?php
                        $payable = $payment->payable;
                        $serviceDetails = [];
                       
                        switch ($payment->payable_type) {
                            case 'App\Models\Salary':
                                $serviceDetails = [
                                    'Service' => 'Staff Salary Payment',
                                    'Employee' => $payable->employee?->name ?? 'Employee #' . ($payable->employee_id ?? 'N/A'),
                                    'Period' => $payable->period ?? 'Not Specified',
                                    'Department' => $payable->employee?->department ?? 'N/A'
                                ];
                                break;
                               
                            case 'App\Models\OfficeUtility':
                                $serviceDetails = [
                                    'Service' => 'Office Utility Payment',
                                    'Utility Type' => $payable->type ?? 'General Office Expense',
                                    'Period' => $payable->period ?? 'Current Period',
                                    'Description' => $payable->description ?? 'Office utility expense'
                                ];
                                break;
                               
                            case 'App\Models\Project':
                                $serviceDetails = [
                                    'Service' => 'Legal Project Services',
                                    'Project Name' => $payable->name ?? 'Project #' . $payment->payable_id,
                                    'Project Type' => $payable->type ?? 'Legal Services',
                                    'Start Date' => $payable->start_date ? $payable->start_date->format('F j, Y') : 'N/A',
                                    'Status' => $payable->status ? strtoupper($payable->status) : 'N/A'
                                ];
                                break;
                               
                            case 'App\Models\Conveyancing':
                                $serviceDetails = [
                                    'Service' => 'Conveyancing Services',
                                    'File Number' => $payable->serial_number ?? 'Conv #' . $payment->payable_id,
                                    'Property' => $payable->property_description ?? 'Property conveyancing',
                                    'Transaction Type' => $payable->transaction_type ?? 'Property Transfer',
                                    'Buyer' => $payable->buyer?->user?->name ?? 'Buyer #' . ($payable->buyer_id ?? 'N/A'),
                                    'Seller' => $payable->seller?->user?->name ?? 'Seller #' . ($payable->seller_id ?? 'N/A')
                                ];
                                if ($payment->type) {
                                    $serviceDetails['Payment Type'] = ucwords(str_replace('_', ' ', $payment->type));
                                }
                                break;
                               
                            case 'App\Models\Litigation':
                                $serviceDetails = [
                                    'Service' => 'Legal Litigation Services',
                                    'Case Number' => $payable->case_number ?? 'Lit #' . $payment->payable_id,
                                    'Case Title' => $payable->case_title ?? 'Legal Matter',
                                    'Court' => $payable->court ?? 'N/A',
                                    'Case Status' => $payable->status ? strtoupper($payable->status) : 'N/A'
                                ];
                                break;
                        }
                    ?>
                   
                    <table class="details-table">
                        <?php $__currentLoopData = $serviceDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="label"><?php echo e($label); ?></td>
                            <td class="value"><?php echo e($value); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
            <?php endif; ?>

            <!-- Amount Section -->
            <div class="amount-section">
                <div class="amount-label">
                    <?php echo e($payment->direction === 'incoming' ? 'Amount Received' : 'Amount Paid'); ?>

                </div>
                <div class="amount-value">KSh <?php echo e(number_format($payment->amount_paid, 2)); ?></div>
                <div class="amount-words">
                    <?php
                        // Convert amount to words (you might want to create a helper for this)
                        $amount = $payment->amount_paid;
                        $formatter = new NumberFormatter('en', NumberFormatter::SPELLOUT);
                        $words = $formatter->format(floor($amount));
                        $cents = ($amount - floor($amount)) * 100;
                        $amountInWords = ucfirst($words) . ' Kenya Shillings';
                        if ($cents > 0) {
                            $centWords = $formatter->format($cents);
                            $amountInWords .= ' and ' . ucfirst($centWords) . ' Cents';
                        }
                        $amountInWords .= ' Only';
                    ?>
                    (<?php echo e($amountInWords); ?>)
                </div>
            </div>

            <!-- Payment Purpose -->
            <?php if($payment->type || $payment->direction === 'outgoing'): ?>
            <div class="section">
                <div class="section-title">Purpose of <?php echo e($payment->direction === 'incoming' ? 'Payment' : 'Expenditure'); ?></div>
                <table class="details-table">
                    <tr>
                        <td class="label">Description</td>
                        <td class="value">
                            <?php if($payment->direction === 'incoming'): ?>
                                <?php if($payment->type): ?>
                                    <?php echo e(ucwords(str_replace('_', ' ', $payment->type))); ?>

                                <?php else: ?>
                                    Legal Services Payment
                                <?php endif; ?>
                            <?php else: ?>
                                <?php switch($payment->payable_type):
                                    case ('App\Models\Salary'): ?>
                                        Staff Salary Payment
                                        <?php break; ?>
                                    <?php case ('App\Models\OfficeUtility'): ?>
                                        Office Utility Expense
                                        <?php break; ?>
                                    <?php default: ?>
                                        Business Expense
                                <?php endswitch; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
            <?php endif; ?>

            <!-- Signature Section -->
            <div class="signature-section">
                <div class="signature-box">
                    <div class="signature-line"></div>
                    <div class="signature-label">RECEIVED BY</div>
                </div>
                <div class="signature-box">
                    <div class="signature-line"></div>
                    <div class="signature-label">AUTHORIZED SIGNATURE</div>
                </div>
            </div>
        </div>

        <!-- Footer Section -->
        <div class="receipt-footer">
            <div class="footer-text">
                <strong>TERMS & CONDITIONS:</strong><br>
                This receipt is valid for all legal purposes. Please retain this receipt for your records.<br>
                All payments are final unless otherwise stated in writing.
            </div>
           
            <div class="footer-text" style="margin-top: 15px;">
                <strong>Receipt Generated:</strong> <?php echo e(now()->format('F j, Y \a\t h:i A')); ?><br>
                <strong>System Reference:</strong> <?php echo e(strtoupper(md5($payment->id . $payment->created_at))); ?>

            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/reports/payment-receipt.blade.php ENDPATH**/ ?>