<?php
    $groupedPayments = $payments->groupBy('conveyancing_id');
    $grandTotal = 0;
?>

<!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $groupedPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conveyancingId => $paymentGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <?php
        $conveyancing = $paymentGroup->first()->conveyancing ?? null;
        $total = $paymentGroup->sum('amount_paid');
        $grandTotal += $total;
    ?>

    <div class="mb-6">
        <h3 class="text-left font-semibold text-sm mb-2">
            Conveyancing: <?php echo e($conveyancing->property_address ?? 'Property #'.$conveyancingId); ?>

        </h3>
        <div class="overflow-x-auto">
         <table class="w-full min-w-full border border-gray-300 divide-y divide-gray-200 text-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border border-gray-200 px-4 py-2">Paid To</th>
                    <th class="border border-gray-200 px-4 py-2">Paid By</th>
                    <th class="border border-gray-200 px-4 py-2">Amount Received</th>
                    <th class="border border-gray-200 px-4 py-2">Method</th>
                    <th class="border border-gray-200 px-4 py-2">Transaction ID</th>
                    <th class="border border-gray-200 px-4 py-2">Status</th>
                    <th class="border border-gray-200 px-4 py-2">Created At</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $status = strtolower($payment->status);
                        $badgeClasses = match ($status) {
                            'confirmed' => 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300',
                            'pending' => 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/50 dark:text-yellow-300',
                            'failed' => 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300',
                            default => 'bg-gray-100 text-gray-800 dark:bg-gray-900/50 dark:text-gray-300',
                        };
                    ?>
                    <tr>
                        <td class="border border-gray-200 px-4 py-2"> <?php echo e(($payment->client->user->name)); ?></td>
                        <td class="border border-gray-200 px-4 py-2"> <?php echo e(($payment->paidBy->user->name ?? 'NA')); ?></td>
                        <td class="border border-gray-200 px-4 py-2">Ksh <?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                        <td class="border border-gray-200 px-4 py-2"><?php echo e(ucfirst($payment->payment_method)); ?></td>
                        <td class="border border-gray-200 px-4 py-2"><?php echo e($payment->transaction_id ?? '-'); ?></td>
                        <td class="border border-gray-200 px-4 py-2">
                            <span class="inline-block px-3 py-1 text-xs font-semibold rounded-full <?php echo e($badgeClasses); ?>">
                                <?php echo e(ucfirst($payment->status)); ?>

                            </span>
                        </td>
                         <td class="border border-gray-200 px-4 py-2">
                    <?php echo e(\Carbon\Carbon::parse($payment->created_at)->format('M d, Y') ?? 'N/A'); ?>

                </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                <tr class="font-bold bg-gray-100 dark:bg-gray-800">
                    <td colspan="1" class="border border-gray-200 px-4 py-2 text-right">Total:</td>
                    <td colspan="4" class="border border-gray-200 px-4 py-2 text-left">
                        Ksh <?php echo e(number_format($total, 2)); ?>

                    </td>
                </tr>
            </tbody>
        </table>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <p class="text-center text-gray-500">No conveyancing payments found for this client.</p>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!--[if BLOCK]><![endif]--><?php if($payments->count()): ?>
    <div class="mt-4 text-right font-bold text-sm">
        Grand Total: Ksh <?php echo e(number_format($grandTotal, 2)); ?>

    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/client-components/client-conveyancing-payments-table.blade.php ENDPATH**/ ?>