<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['payment']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['payment']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Receipt #<?php echo e($payment->id); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
            font-size: 14px;
            line-height: 1.5;
        }
        .container {
            width: 80%;
            max-width: 600px;
            margin: 20px auto;
            border: 1px solid #ddd;
            padding: 20px;
            background: #fff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #000;
        }
        .header p {
            margin: 5px 0;
            font-size: 12px;
            color: #666;
        }
        .details {
            margin-bottom: 20px;
        }
        .details table {
            width: 100%;
            border-collapse: collapse;
        }
        .details th, .details td {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
            text-align: left;
        }
        .details th {
            width: 40%;
            font-weight: bold;
        }
        .total {
            text-align: right;
            margin-top: 20px;
            font-size: 18px;
            font-weight: bold;
            border-top: 2px solid #ddd;
            padding-top: 10px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 12px;
            color: #888;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Payment Receipt</h1>
            <p>Receipt Number: #<?php echo e($payment->id); ?></p>
            <p>Date: <?php echo e($payment->created_at->format('d M Y H:i')); ?></p>
        </div>

        <div class="details">
            <table>
                <tr>
                    <th>Direction:</th>
                    <td><?php echo e(ucfirst($payment->direction)); ?></td>
                </tr>
                <tr>
                    <th>Type:</th>
                    <td><?php echo e(str_replace('App\\Models\\', '', $payment->payable_type)); ?></td>
                </tr>
                <tr>
                    <th>Related Entity:</th>
                    <td>
                        <?php
                            $payable = $payment->payable;
                            $entityDetail = '-';
                            if ($payable) {
                                switch ($payment->payable_type) {
                                    case 'App\Models\Salary':
                                        $name = $payable->employee?->name ?? 'Employee';
                                        $period = $payable->period ?? 'No Period';
                                        $entityDetail = $name . ' (' . $period . ')';
                                        break;
                                    case 'App\Models\OfficeUtility':
                                        $type = $payable->type ?? 'Utility';
                                        $period = $payable->period ?? 'No Period';
                                        $entityDetail = $type . ' (' . $period . ')';
                                        break;
                                    case 'App\Models\Project':
                                        $entityDetail = $payable->name ?? 'Project';
                                        break;
                                    case 'App\Models\Conveyancing':
                                        $entityDetail = $payable->serial_number ?? 'Conveyancing';
                                        break;
                                    case 'App\Models\Litigation':
                                        $entityDetail = $payable->case_number ?? 'Litigation';
                                        break;
                                }
                            }
                        ?>
                        <?php echo e($entityDetail); ?>

                    </td>
                </tr>
                <?php if($payment->client_id): ?>
                <tr>
                    <th>Client:</th>
                    <td><?php echo e($payment->client?->user?->name ?? $payment->client?->phone ?? 'Client #' . $payment->client_id); ?></td>
                </tr>
                <?php endif; ?>
                <?php if($payment->direction === 'incoming' && $payment->payable_type === 'App\Models\Conveyancing' && $payment->paid_by): ?>
                <tr>
                    <th>Paid By:</th>
                    <td><?php echo e($payment->paidBy?->user?->name ?? 'Client #' . $payment->paid_by); ?> (<?php echo e($payment->paid_by == $payment->payable?->buyer_id ? 'Buyer' : 'Seller'); ?>)</td>
                </tr>
                <tr>
                    <th>For:</th>
                    <td><?php echo e(ucwords(str_replace('_', ' ', $payment->type ?? 'N/A'))); ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <th>Amount:</th>
                    <td>KSh <?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                </tr>
                <tr>
                    <th>Method:</th>
                    <td><?php echo e(ucfirst($payment->payment_method)); ?></td>
                </tr>
                <?php if($payment->account_id): ?>
                <tr>
                    <th>Account:</th>
                    <td><?php echo e($payment->account->name); ?> (<?php echo e($payment->account->number); ?>)</td>
                </tr>
                <?php endif; ?>
                <tr>
                    <th>Transaction ID:</th>
                    <td><?php echo e($payment->transaction_id ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Status:</th>
                    <td><?php echo e(ucfirst($payment->status)); ?></td>
                </tr>
            </table>
        </div>

        <div class="total">
            Total Paid: KSh <?php echo e(number_format($payment->amount_paid, 2)); ?>

        </div>

        <div class="footer">
            Thank you for your payment. This is a computer-generated receipt.
        </div>
    </div>
</body>
</html><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/reports/payment.blade.php ENDPATH**/ ?>