<?php $__env->startPush('styles'); ?>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 5px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        h2,
        h3 {
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 40px;
        }

        .pdf-icon {
            width: 20px;
            height: 20px;
            vertical-align: middle;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php
    // Use project if passed, otherwise fall back to projectRecord
    $projectData = $project ?? ($projectRecord ?? null);
    $document = $document ?? ($projectData->document ?? null);
?>

<div class="p-4">
    <!--[if BLOCK]><![endif]--><?php if(!$projectData): ?>
        <p class="text-gray-500 dark:text-gray-400">No project details found.</p>
    <?php else: ?>
        <!--[if BLOCK]><![endif]--><?php if(!empty($projectData->serial_number)): ?>
            <div class="mb-4 text-center">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
                    Referrence Number: <span
                        class="text-primary-600 dark:text-primary-400"><?php echo e($projectData->serial_number); ?></span>
                </h2>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Project Details Table -->
        <div class="overflow-x-auto">
            <table class="w-full min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">Project Name</th>
                        <th class="px-4 py-2 text-left">Point of Contact</th>
                        <th class="px-4 py-2 text-left">Location</th>
                        <th class="px-4 py-2 text-left">Number of Units</th>
                        <th class="px-4 py-2 text-left">Type</th>
                        <th class="px-4 py-2 text-left">Description</th>
                        <th class="px-4 py-2 text-left">Documents</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border-t dark:border-gray-600">
                        <td class="px-4 py-2"><?php echo e($projectData->name ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($projectData->poc ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($projectData->location ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e($projectData->number_of_units ?? 'N/A'); ?></td>
                        <td class="px-4 py-2"><?php echo e(ucfirst($projectData->type ?? 'N/A')); ?></td>
                        <td class="px-4 py-2"><?php echo e($projectData->description ?? 'N/A'); ?></td>
                        <td class="px-4 py-2">
                            <!--[if BLOCK]><![endif]--><?php if($documents && $documents->isNotEmpty()): ?>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                                        $iconMap = [
                                            'pdf' => 'pdf-icon.png',
                                            'doc' => 'word-icon.png',
                                            'docx' => 'word-icon.png',
                                            'xls' => 'excel-icon.png',
                                            'xlsx' => 'excel-icon.png',
                                            'jpg' => 'image-icon.png',
                                            'jpeg' => 'image-icon.png',
                                            'png' => 'image-icon.png',
                                            'txt' => 'text-icon.png',
                                        ];

                                        $icon = $iconMap[$extension] ?? 'file-icon.png'; // fallback
                                    ?>

                                    <div class="mb-2">
                                        <a href="<?php echo e(asset('storage/' . $document->file_path)); ?>" target="_blank"
                                            class="flex items-center">
                                            <img src="<?php echo e(asset('images/' . $icon)); ?>" alt="<?php echo e(strtoupper($extension)); ?>"
                                                class="pdf-icon">
                                        </a>
                                        <p><?php echo e($document->name); ?></p>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            <?php else: ?>
                                N/A
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>

                    </tr>
                </tbody>
            </table>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/project-components/project-details-table.blade.php ENDPATH**/ ?>