<?php
    $totalExpenses = $expenses->sum('amount_paid');
?>

<div class="overflow-x-auto">
    <table class="w-full min-w-full text-center">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                 <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase tracking-wide">
                    Type
                </th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase tracking-wide">
                    Paid Against             
                </th>
             
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase tracking-wide">
                    Amount (Ksh)
                </th>
            </tr>
        </thead>
        <tbody>
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 capitalize">
                        <?php echo e(str_replace('_', ' ', $expense->expenseItem->expense_item ?? 'other')); ?>

                    </td>
                    <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 capitalize">
                        <?php
                            $paidTo = 'N/A';
                            if ($expense->client) {
                                $name = $expense->client->user?->name ?? 'Client #' . $expense->client_id;
                                if ($expense->expensable_type === 'App\\Models\\Conveyancing') {
                                    $convey = $expense->expensable;
                                    if ($expense->client_id == $convey->buyer_id) {
                                        $paidTo = $name . ' (Buyer)';
                                    } elseif ($expense->client_id == $convey->seller_id) {
                                        $paidTo = $name . ' (Seller)';
                                    } else {
                                        $paidTo = $name;
                                    }
                                } else {
                                    $paidTo = $name;
                                }
                            }
                        ?>
                        <?php echo e($paidTo); ?>

                    </td>
               
                    <td class="border border-gray-200 px-4 py-2 text-gray-900 dark:text-gray-100 font-medium">
                        <?php echo e(number_format($expense->amount_paid, 2)); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" class="border border-gray-200 px-4 py-2 text-gray-500 dark:text-gray-400 text-base">
                        No expenses found.
                    </td>
                </tr>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($expenses->count()): ?>
                <tr class="bg-gray-100 dark:bg-gray-800 font-semibold">
                    <td class="border border-gray-300 px-4 py-2 text-right text-gray-700 dark:text-gray-200" colspan="2">
                        Total Expenses:
                    </td>
                    <td class="border border-gray-300 px-4 py-2 text-gray-900 dark:text-gray-100">
                        <?php echo e(number_format($totalExpenses, 2)); ?>

                    </td>
                </tr>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </tbody>
    </table>
</div><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/conveyancing-components/conveyancing-expense-details-table.blade.php ENDPATH**/ ?>