<!-- resources/views/pdf/project-client.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Client Details - <?php echo e($projectClient->client->user->name ?? 'N/A'); ?></title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 20px;
        }
        h1 {
            font-size: 18px;
            margin-bottom: 10px;
        }
        h2 {
            font-size: 14px;
            margin-top: 20px;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .section {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    <h1>Client Details for <?php echo e($projectClient->client->user->name ?? 'N/A'); ?></h1>
    <p>Project: <?php echo e($project->name); ?></p>

    <div class="section">
        <h2>Client Information</h2>
        <table>
            <tr>
                <th>Name</th>
                <td><?php echo e($projectClient->client->user->name ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>National ID</th>
                <td><?php echo e($projectClient->client->national_id ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Phone</th>
                <td><?php echo e($projectClient->client->phone ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>KRA Pin</th>
                <td><?php echo e($projectClient->client->kra_pin ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Passport Number</th>
                <td><?php echo e($projectClient->client->passport_number ?? 'N/A'); ?></td>
            </tr>
            
            <tr>
                <th>Nationality</th>
                <td><?php echo e($projectClient->client->nationality ?? 'N/A'); ?></td>
            </tr>
        </table>
    </div>

    <?php
        $amountCharged = $projectClient->apartmentDetail->amount_charged
            ?? $projectClient->subdivisionDetail->amount_charged
            ?? 0;

        $totalPaid = $projectClient->projectClientPayments->sum('amount_paid');
        $balance = $amountCharged - $totalPaid;
    ?>

    <?php if($projectClient->apartmentDetail): ?>
        <div class="section">
            <h2>Apartment Details</h2>
            <table>
                <tr>
                    <th>Floor</th>
                    <td><?php echo e($projectClient->apartmentDetail->floor ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Unit Name</th>
                    <td><?php echo e($projectClient->apartmentDetail->flat_name ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Unit Type</th>
                    <td><?php echo e($projectClient->apartmentDetail->unit_type ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Owner 2</th>
                    <td><?php echo e($projectClient->apartmentDetail->owner2 ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Amount Charged</th>
                    <td><?php echo e(number_format($amountCharged, 2)); ?></td>
                </tr>
            </table>
        </div>
    <?php elseif($projectClient->subdivisionDetail): ?>
        <div class="section">
            <h2>Subdivision Details</h2>
            <table>
                <tr>
                    <th>Plot Number</th>
                    <td><?php echo e($projectClient->subdivisionDetail->plot_number ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Size</th>
                    <td><?php echo e($projectClient->subdivisionDetail->size ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Owner 2</th>
                    <td><?php echo e($projectClient->subdivisionDetail->owner2 ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Amount Charged</th>
                    <td><?php echo e(number_format($amountCharged, 2)); ?></td>
                </tr>
            </table>
        </div>
    <?php endif; ?>

    <div class="section">
        <h2>Client Payments</h2>
        <?php if($projectClient->projectClientPayments->isNotEmpty()): ?>
            <table>
                <thead>
                    <tr>
                        <th>Paid BY</th>
                        <th>Payment Method</th>
                        <th>Transaction ID</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $projectClient->projectClientPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($payment->client->user->name ?? 'N/A'); ?></td>
                            <td><?php echo e(ucfirst($payment->payment_method ?? 'N/A')); ?></td>
                            <td><?php echo e($payment->transaction_id ?? 'N/A'); ?></td>
                            <td><?php echo e(number_format($payment->amount_paid ?? 0, 2)); ?></td>
                            <td><?php echo e(ucfirst($payment->status ?? 'N/A')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th colspan="3" style="text-align:right">Total Paid:</th>
                        <td colspan="2"><?php echo e(number_format($totalPaid, 2)); ?></td>
                    </tr>
                    <tr>
                        <th colspan="3" style="text-align:right">Balance:</th>
                        <td colspan="2"><?php echo e(number_format($balance, 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        <?php else: ?>
            <p>No payments found.</p>
        <?php endif; ?>
    </div>

</body>
</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/project-client.blade.php ENDPATH**/ ?>