<?php
    function getIconPath($filePath)
    {
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        return match ($extension) {
            'pdf' => 'images/pdf-icon.png',
            'doc', 'docx' => 'images/word-icon.png',
            'xls', 'xlsx' => 'images/excel-icon.png',
            'jpg', 'jpeg', 'png', 'gif' => 'storage/' . $filePath,
            default => 'images/file-icon.png',
        };
    }
?>

<!--[if BLOCK]><![endif]--><?php if(!empty($case_number)): ?>
    <div class="mb-4 text-justify">
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            System Generated Case Number: <span class="text-primary-600 dark:text-primary-400"><?php echo e($case_number); ?></span>
        </h2>
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            Court Assigned Case Number: <span
                class="text-primary-600 dark:text-primary-400"><?php echo e($court_assigned_case_number); ?></span>
        </h2>
        <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
            Case Citation: <span class="text-primary-600 dark:text-primary-400"><?php echo e(strtoupper($description)); ?></span>
        </h2>
        
    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<div class="overflow-x-auto">
    <table class="w-full min-w-full text-center">
        <thead class="bg-gray-50 dark:bg-gray-900/50">
            <tr>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Court</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Case Type</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Case Category
                </th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Description</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Amount Charged</th>
                <th class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-200 uppercase">Documents</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300"><?php echo e($court ?? 'N/A'); ?></td>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300"><?php echo e($type ?? 'N/A'); ?></td>
                <td class="border border-gray-200 px-4 py-2 text-gray-700 dark:text-gray-300">
                    <?php echo e($case_category ?? 'N/A'); ?></td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 italic">
                    <?php echo e($description ?? 'N/A'); ?>

                </td>
                <td class="border border-gray-200 px-4 py-2 text-gray-600 dark:text-gray-300 ">
                    <?php echo e(number_format($amount_charged,2) ?? 'N/A'); ?>

                </td>
                <td class="border border-gray-200 px-4 py-2">
                        <!--[if BLOCK]><![endif]--><?php if($documents && $documents->isNotEmpty()): ?>
                            <div class="grid grid-cols-2 gap-3 ">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                                        $iconMap = [
                                            'pdf' => 'pdf-icon.png',
                                            'doc' => 'word-icon.png',
                                            'docx' => 'word-icon.png',
                                            'xls' => 'excel-icon.png',
                                            'xlsx' => 'excel-icon.png',
                                            'jpg' => 'image-icon.png',
                                            'jpeg' => 'image-icon.png',
                                            'png' => 'image-icon.png',
                                            'txt' => 'text-icon.png',
                                        ];

                                        $icon = $iconMap[$extension] ?? 'file-icon.png';
                                    ?>

                                    <div class="flex flex-col items-center text-center">
                                        <a href="<?php echo e(asset('storage/' . $document->file_path)); ?>" target="_blank"
                                            class="flex justify-center">
                                            <img src="<?php echo e(asset('images/' . $icon)); ?>" alt="<?php echo e(strtoupper($extension)); ?>"
                                                class="h-6 w-6 object-contain hover:scale-110 transition">
                                        </a>
                                        <p class="mt-1 text-xs text-gray-700 dark:text-gray-300 truncate w-full">
                                            <?php echo e($document->name); ?>

                                        </p>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php else: ?>
                            <span class="text-gray-500 dark:text-gray-400 italic">N/A</span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
            </tr>
        </tbody>
    </table>
</div><?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/litigation-components/litigation-details-table.blade.php ENDPATH**/ ?>