<table class="w-full min-w-full text-center mt-6">
    <thead class="bg-gray-50 dark:bg-gray-900/50">
        <tr>
            <th class="border border-gray-200 px-4 py-2">Date</th>
            <th class="border border-gray-200 px-4 py-2">Method</th>
            <th class="border border-gray-200 px-4 py-2">Amount (KES)</th>
            <th class="border border-gray-200 px-4 py-2">Payable Type</th>
            <th class="border border-gray-200 px-4 py-2">Reference</th>
        </tr>
    </thead>

    <tbody class="divide-y divide-gray-100 dark:divide-gray-700">
        <?php $payment = $payment ?? ($payments ?? null); ?>
        <!--[if BLOCK]><![endif]--><?php if($payment): ?>
            <tr>
                <td class="border border-gray-200 px-4 py-2"><?php echo e($payment->created_at->format('d M Y')); ?></td>
                <td class="border border-gray-200 px-4 py-2"><?php echo e(ucfirst($payment->payment_method)); ?></td>
                <td class="border border-gray-200 px-4 py-2"><?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                <td class="border border-gray-200 px-4 py-2"><?php echo e(class_basename($payment->payable_type)); ?></td>
                <td class="border border-gray-200 px-4 py-2">
                    <!--[if BLOCK]><![endif]--><?php if($payment->payable_type === \App\Models\Conveyancing::class): ?>
                        <?php echo e($payment->payable?->serial_number ?? 'N/A'); ?>

                    <?php elseif($payment->payable_type === \App\Models\Litigation::class): ?>
                        <?php echo e($payment->payable?->case_number ?? 'N/A'); ?>

                    <?php elseif($payment->payable_type === \App\Models\Project::class): ?>
                        <?php echo e($payment->payable?->name ?? 'N/A'); ?>    
                    <?php else: ?>
                        <?php echo e($payment->payable_id ?? 'N/A'); ?>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
            </tr>
        <?php else: ?>
            <tr>
                <td colspan="7" class="text-center py-4 text-gray-500">No payment data found.</td>
            </tr>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </tbody>
</table>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/payment-components/payment-details.blade.php ENDPATH**/ ?>