<div class="overflow-x-auto rounded-md shadow-md border border-gray-200 dark:border-gray-700">
    <table class="w-full text-sm text-left text-gray-600 dark:text-gray-300">
        <thead class="text-xs uppercase bg-gray-100 dark:bg-gray-800 dark:text-gray-400">
            <tr>
                <th class="px-4 py-2 border">Field</th>
                <th class="px-4 py-2 border">Value</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-900">
            <tr>
                <td class="px-4 py-2 border font-medium">Expense Item</td>
                <td class="px-4 py-2 border">
                    <?php echo e($expense->expenseItem->expense_item ?? '—'); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Amount Paid</td>
                <td class="px-4 py-2 border">
                    KES <?php echo e(number_format($expense->amount_paid, 2)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Balance</td>
                <td class="px-4 py-2 border">
                    KES <?php echo e(number_format($expense->balance, 2)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Payment Method</td>
                <td class="px-4 py-2 border">
                    <?php echo e(ucfirst($expense->payment_method)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Status</td>
                <td class="px-4 py-2 border">
                    <?php echo e(ucfirst($expense->status)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Expensable Type</td>
                <td class="px-4 py-2 border">
                    <?php echo e(class_basename($expense->expensable_type)); ?>

                </td>
            </tr>
            <tr>
                <td class="px-4 py-2 border font-medium">Related To</td>
                <td class="px-4 py-2 border">
                    <?php
                        $expensable = $expense->expensable;
                    ?>

                    <!--[if BLOCK]><![endif]--><?php if($expensable): ?>
                        <!--[if BLOCK]><![endif]--><?php switch(class_basename($expensable)):
                            case ('Conveyancing'): ?>
                                Conveyancing – <?php echo e($expensable->serial_number ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php case ('Litigation'): ?>
                                Litigation – <?php echo e($expensable->case_number ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php case ('Project'): ?>
                                Project – <?php echo e($expensable->name ?? 'N/A'); ?>

                            <?php break; ?>

                            <?php default: ?>
                                <?php echo e(class_basename($expensable)); ?> – #<?php echo e($expensable->id); ?>

                        <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                    <?php else: ?>
                        <span class="text-gray-500 italic">No associated record</span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
            </tr>

        </tbody>
    </table>
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/expense-components/expense-details.blade.php ENDPATH**/ ?>