<?php
    // Use passed expenses or fallback
    $expenses = $expenses ?? collect();

    // Calculate total expenses
    $totalExpenses = $expenses->sum('amount_paid');
?>

<div class="p-4">
    <!--[if BLOCK]><![endif]--><?php if($expenses->isEmpty()): ?>
        <p class="text-gray-500 dark:text-gray-400">No expenses found for this litigation.</p>
    <?php else: ?>
        <!-- Litigation Expenses Table -->
        <div class="overflow-x-auto">
            <table class="w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">Expense</th>
                        <th class="px-4 py-2 text-left">Amount Paid</th>
                        <th class="px-4 py-2 text-left">Payment Method</th>
                        
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-t dark:border-gray-600">
                            <td class="px-4 py-2">
                                <?php echo e($expense->expenseItem->expense_item ?? 'N/A'); ?>

                            </td>
                            <td class="px-4 py-2">
                                <?php echo e(number_format($expense->amount_paid ?? 0, 2)); ?> KES
                            </td>
                            <td class="px-4 py-2">
                                <?php echo e(ucfirst($expense->payment_method ?? 'N/A')); ?>

                            </td>
                            
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
                <tfoot>
                    <tr class="bg-gray-50 dark:bg-gray-800 font-bold">
                        <td class="px-4 py-2">Total</td>
                        <td class="px-4 py-2">
                            <?php echo e(number_format($totalExpenses, 2)); ?> KES
                        </td>
                        <td class="px-4 py-2" colspan="2"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/infolists/litigation-components/litigation-expense-details-table.blade.php ENDPATH**/ ?>