<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Conveyancing Financial Summary</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 13px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
        }

        th {
            background: #eee;
        }

        h1,
        h2 {
            margin-top: 20px;
        }

        .profit {
            color: green;
            font-weight: bold;
        }

        .loss {
            color: red;
            font-weight: bold;
        }
    </style>
</head>

<body>
    
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>

    <h1>Conveyancing Financial Summary</h1>

    <h2>Transaction Info</h2>
    <table>
        <tr>
            <th>Serial Number</th>
            <td><?php echo e($record->serial_number); ?></td>
        </tr>
        <tr>
            <th>Property</th>
            <td><?php echo e($record->property_address); ?></td>
        </tr>
        <tr>
            <th>Sale Price</th>
            <td>KES <?php echo e(number_format($record->sale_price, 2)); ?></td>
        </tr>
        <tr>
            <th>Contract Date</th>
            <td><?php echo e($record->contract_date ? \Carbon\Carbon::parse($record->contract_date)->format('F j, Y') : 'N/A'); ?>

            </td>
        </tr>
        <tr>
            <th>Completion Period</th>
            <td><?php echo e($record->completion_period ? \Carbon\Carbon::parse($record->completion_period)->format('F j, Y') : 'N/A'); ?>

            </td>
        </tr>
    </table>

    <?php
        $totalExpenses = $record->expenses->sum('amount_paid');
        $buyerAgreedFees = $record->buyer_legal_fees ?? 0;
        $sellerAgreedFees = $record->seller_legal_fees ?? 0;
        $agreedFees = $buyerAgreedFees + $sellerAgreedFees;
        $profit = $agreedFees - $totalExpenses;

        $totalLegalFees = $record->conveyancingPayments->where('type', 'legal_fees')->sum('amount_paid');
        $totalPurchasePrice = $record->conveyancingPayments->where('type', 'purchase_price')->sum('amount_paid');

        $outstandingBalance = $agreedFees - $totalLegalFees;

        $buyerPayments = $record->conveyancingPayments->where('paid_by', $record->buyer_id);
        $sellerPayments = $record->conveyancingPayments->where('paid_by', $record->seller_id);

        $buyerLegalFeesPaid = $buyerPayments->where('type', 'legal_fees')->sum('amount_paid');
        $sellerLegalFeesPaid = $sellerPayments->where('type', 'legal_fees')->sum('amount_paid');
    ?>

    <h2>Financial Summary</h2>
    <table>
        <tr>
            <th>( <?php echo e($record->buyer->user->name ?? 'N/A'); ?> ) - Buyer Agreed Legal Fees</th>
            <td>KES <?php echo e(number_format($buyerAgreedFees, 2)); ?></td>
        </tr>
        <tr>
            <th>( <?php echo e($record->seller->user->name ?? 'N/A'); ?> ) Seller Agreed Legal Fees</th>
            <td>KES <?php echo e(number_format($sellerAgreedFees, 2)); ?></td>
        </tr>
        <tr>
            <th>Agreed Legal Fees (Buyer + Seller)</th>
            <td>KES <?php echo e(number_format($agreedFees, 2)); ?></td>
        </tr>
        <tr>
            <th>Total Expenses</th>
            <td>KES <?php echo e(number_format($totalExpenses, 2)); ?></td>
        </tr>
        
        <tr>
            <th>Total Legal Fees Received</th>
            <td>KES <?php echo e(number_format($totalLegalFees, 2)); ?></td>
        </tr>
        <tr>
            <th>Outstanding Balance (Agreed Fees - Legal Fees Received)</th>
            <td style="color:red;">KES <?php echo e(number_format($outstandingBalance, 2)); ?></td>
        </tr>
    </table>

    <?php if($buyerPayments->where('type', 'legal_fees')->count()): ?>
        <h2>Buyer Legal Fees Payments -( <?php echo e($record->buyer->user->name ?? 'N/A'); ?> )</h2>
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payer Name</th>
                    <th>Amount Paid</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $buyerPayments->where('type', 'legal_fees'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($payment->created_at ? $payment->created_at->format('F j, Y') : 'N/A'); ?></td>
                        <td><?php echo e($record->buyer->user->name ?? 'N/A'); ?></td>
                        <td>KES <?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="background:#ccc;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Total Paid</td>
                    <td style="font-weight: bold;">KES <?php echo e(number_format($buyerLegalFeesPaid, 2)); ?></td>
                </tr>
                <tr style="background:#eee;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Balance</td>
                    <td style="font-weight: bold; color: red;">
                        KES <?php echo e(number_format($buyerAgreedFees - $buyerLegalFeesPaid, 2)); ?>

                    </td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if($sellerPayments->where('type', 'legal_fees')->count()): ?>
        <h2>Seller Legal Fees Payments - ( <?php echo e($record->seller->user->name ?? 'N/A'); ?> )</h2>
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payer Name</th>
                    <th>Amount Paid</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $sellerPayments->where('type', 'legal_fees'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($payment->created_at ? $payment->created_at->format('F j, Y') : 'N/A'); ?></td>
                        <td><?php echo e($record->seller->user->name ?? 'N/A'); ?></td>
                        <td>KES <?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="background:#ccc;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Total Paid</td>
                    <td style="font-weight: bold;">KES <?php echo e(number_format($sellerLegalFeesPaid, 2)); ?></td>
                </tr>
                <tr style="background:#eee;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Balance</td>
                    <td style="font-weight: bold; color: red;">
                        KES <?php echo e(number_format($sellerAgreedFees - $sellerLegalFeesPaid, 2)); ?>

                    </td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>

    <?php if($buyerPayments->where('type', 'purchase_price')->count()): ?>
        <h2>Buyer Purchase Price Payments-( <?php echo e($record->buyer->user->name ?? 'N/A'); ?> )</h2>
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payer Name</th>
                    <th>Amount Paid</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $buyerPurchasePayments = $buyerPayments->where('type', 'purchase_price');
                    $buyerPurchaseTotal = $buyerPurchasePayments->sum('amount_paid');
                    $purchaseBalance = $record->sale_price - $buyerPurchaseTotal;
                ?>

                <?php $__currentLoopData = $buyerPurchasePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($payment->created_at ? $payment->created_at->format('F j, Y') : 'N/A'); ?></td>
                        <td><?php echo e($record->buyer->user->name ?? 'N/A'); ?></td>
                        <td>KES <?php echo e(number_format($payment->amount_paid, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <tr style="background:#ccc;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Total Paid</td>
                    <td style="font-weight: bold;">KES <?php echo e(number_format($buyerPurchaseTotal, 2)); ?></td>
                </tr>
                <tr style="background:#eee;">
                    <td colspan="2" style="text-align: right; font-weight: bold;">Balance</td>
                    <td style="font-weight: bold; color: red;">
                        KES <?php echo e(number_format($purchaseBalance, 2)); ?>

                    </td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>

    <!----Expenses----->
    <?php if($record->expenses->count()): ?>
        <h2>Expenses</h2>
        <table>
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Amount (KES)</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $record->expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($expense->expenseItem->expense_item ?? 'Other'); ?></td>
                        <td>KES <?php echo e(number_format($expense->amount_paid, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr style="background:#eee; font-weight:bold;">
                    <td>Total Expenses</td>
                    <td>KES <?php echo e(number_format($totalExpenses, 2)); ?></td>
                </tr>
            </tbody>
        </table>
    <?php endif; ?>




</body>

</html>
<?php /**PATH /home/djanicok/public_html/LawfirmMS/resources/views/pdf/conveyancing-summary.blade.php ENDPATH**/ ?>