<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Abdulahi Yussuf & Company</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700|merriweather:400,700" rel="stylesheet">

        <!-- Styles / Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="bg-gray-50 dark:bg-gray-900 text-gray-900 dark:text-gray-100 font-sans">
        <!-- Header -->
        <header class="w-full max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6 sticky top-0 bg-gray-50 dark:bg-gray-900 z-10 shadow-sm">
            @if (Route::has('login'))
                <nav class="flex items-center justify-between">
                    <div class="flex items-center">
                        <h1 class="text-2xl font-serif font-bold text-blue-900 dark:text-blue-300">
                            Abdulahi Yussuf & Co.
                        </h1>
                    </div>
                    <div class="flex items-center gap-4">
                        @auth
                            <a href="{{ url('/dashboard') }}"
                               class="inline-block px-5 py-2 border border-blue-600 dark:border-blue-400 text-blue-600 dark:text-blue-400 hover:bg-blue-600 hover:text-white dark:hover:bg-blue-400 dark:hover:text-gray-900 rounded-md text-sm font-medium transition-colors duration-300">
                                Dashboard
                            </a>
                        @else
                            <a href="{{ route('login') }}"
                               class="inline-block px-5 py-2 border border-transparent text-blue-600 dark:text-blue-400 hover:border-blue-600 dark:hover:border-blue-400 rounded-md text-sm font-medium transition-colors duration-300">
                                Log in
                            </a>
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}"
                                   class="inline-block px-5 py-2 border border-blue-600 dark:border-blue-400 text-blue-600 dark:text-blue-400 hover:bg-blue-600 hover:text-white dark:hover:bg-blue-400 dark:hover:text-gray-900 rounded-md text-sm font-medium transition-colors duration-300">
                                    Register
                                </a>
                            @endif
                        @endauth
                    </div>
                </nav>
            @endif
        </header>

        <!-- Hero Section -->
        <section class="bg-gradient-to-r from-blue-900 to-red-800 text-white py-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 class="text-4xl md:text-5xl font-serif font-bold mb-6">
                    Excellence in Legal Solutions
                </h2>
                <p class="text-lg md:text-xl mb-8 max-w-2xl mx-auto">
                    Abdulahi Yussuf & Company delivers unparalleled legal expertise with a commitment to your success.
                </p>
                <a href="#contact"
                   class="inline-block px-8 py-3 bg-red-600 text-white rounded-md text-lg font-medium hover:bg-red-700 dark:hover:bg-red-500 transition-colors duration-300">
                    Schedule a Consultation
                </a>
            </div>
        </section>

        <!-- Services Section -->
        <section class="py-16 bg-gray-50 dark:bg-gray-900">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-3xl font-serif font-bold text-blue-900 dark:text-blue-300 mb-12 text-center">
                    Our Expertise
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <h3 class="text-xl font-semibold text-blue-900 dark:text-blue-300 mb-4">Commercial Law</h3>
                        <p class="text-gray-600 dark:text-gray-300">
                            Strategic legal support for businesses, including contracts, mergers, and compliance.
                        </p>
                    </div>
                    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <h3 class="text-xl font-semibold text-blue-900 dark:text-blue-300 mb-4">Litigation</h3>
                        <p class="text-gray-600 dark:text-gray-300">
                            Robust representation in civil and commercial disputes to protect your interests.
                        </p>
                    </div>
                    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <h3 class="text-xl font-semibold text-blue-900 dark:text-blue-300 mb-4">Intellectual Property</h3>
                        <p class="text-gray-600 dark:text-gray-300">
                            Safeguarding your innovations with expert trademark and patent services.
                        </p>
                    </div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section class="bg-red-50 dark:bg-gray-800 py-16">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-3xl font-serif font-bold text-blue-900 dark:text-blue-300 mb-12 text-center">
                    About Our Firm
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                    <div>
                        <p class="text-lg text-gray-600 dark:text-gray-300 mb-6">
                            Abdulahi Yussuf & Company is a premier law firm dedicated to providing innovative legal solutions. With decades of experience, our team is trusted by clients for our integrity and results-driven approach.
                        </p>
                        <ul class="space-y-4 text-gray-600 dark:text-gray-300">
                            <li class="flex items-center">
                                <svg class="h-6 w-6 text-red-600 dark:text-red-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                Client-Centric Advocacy
                            </li>
                            <li class="flex items-center">
                                <svg class="h-6 w-6 text-red-600 dark:text-red-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                Innovative Strategies
                            </li>
                            <li class="flex items-center">
                                <svg class="h-6 w-6 text-red-600 dark:text-red-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                Proven Expertise
                            </li>
                        </ul>
                    </div>
                    <div class="relative">
                        <img src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?ixlib=rb-4.0.3&auto=format&fit=crop&w=1350&q=80" alt="Abdulahi Yussuf & Company office" class="rounded-lg shadow-md w-full transform hover:scale-105 transition-transform duration-300">
                    </div>
                </div>
            </div>
        </section>

        <!-- Contact Section -->
        <section id="contact" class="py-16 bg-gray-50 dark:bg-gray-900">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-3xl font-serif font-bold text-blue-900 dark:text-blue-300 mb-12 text-center">
                    Get in Touch
                </h2>
                <form class="max-w-lg mx-auto space-y-6">
                    @csrf
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Name</label>
                        <input type="text" id="name" name="name" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:focus:border-blue-400 dark:focus:ring-blue-400 sm:text-sm" required>
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Email</label>
                        <input type="email" id="email" name="email" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:focus:border-blue-400 dark:focus:ring-blue-400 sm:text-sm" required>
                    </div>
                    <div>
                        <label for="message" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Message</label>
                        <textarea id="message" name="message" rows="4" class="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 dark:focus:border-blue-400 dark:focus:ring-blue-400 sm:text-sm" required></textarea>
                    </div>
                    <div>
                        <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 dark:hover:bg-red-500 focus:outline-none focus:ring-2 focus:ring-red-500 dark:focus:ring-red-400 font-medium transition-colors duration-300">
                            Send Message
                        </button>
                    </div>
                </form>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-blue-900 dark:bg-blue-500 text-white py-8">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <p class="text-sm">© {{ date('Y') }} Abdulahi Yussuf & Company. All rights reserved.</p>
            </div>
        </footer>
    </body>
</html>