<x-app-layout>
    <div class="py-6">
        <div class="max-w-4xl mx-auto ">
            <div class="bg-white shadow rounded-md p-6">
                <div class="flex justify-between items-center mb-6 border-b pb-4">
                    <h2 class="text-xl font-semibold text-gray-800">Role Information</h2>
                    <a href="{{ route('roles.index') }}"
                        class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded hover:bg-blue-700">
                        &larr; Back
                    </a>
                </div>

                <div class="space-y-6">
                    <div class="flex flex-col md:flex-row md:items-center">
                        <label for="name" class="w-full md:w-1/3 font-semibold text-gray-700">Name:</label>
                        <div class="w-full md:w-2/3 mt-2 md:mt-0">
                            <span class="text-gray-900">{{ $role->name }}</span>
                        </div>
                    </div>

                    <div class="flex flex-col md:flex-row md:items-start">
                        <label for="permissions"
                            class="w-full md:w-1/3 font-semibold text-gray-700">Permissions:</label>
                        <div class="w-full md:w-2/3 mt-2 md:mt-0">
                            @if ($role->name == 'Super Admin')
                                <span
                                    class="inline-block bg-green-600 text-white text-xs font-semibold rounded px-2 py-1 mr-1 mb-1">All</span>
                            @else
                                @forelse ($rolePermissions as $permission)
                                    <span
                                        class="inline-block bg-green-600 text-white text-xs font-semibold rounded px-2 py-1 mr-1 mb-1">
                                        {{ $permission->name }}
                                    </span>
                                @empty
                                    <span class="text-gray-500 italic">No permissions assigned.</span>
                                @endforelse
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
