<x-app-layout>
    <div class="max-w-7xl mx-auto px-6 py-8"> <!-- Adds margin & padding around the whole content -->
         <!--  Flash Message Components -->
            <x-success-message />
            <x-error-message />
            <!--End Flash Message-->
        <div class="bg-white shadow rounded-md p-6">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-xl font-semibold text-gray-800">Manage Roles</h2>

                @can('create-role')
                    <a href="{{ route('roles.create') }}"
                        class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded hover:bg-green-700">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                        </svg>
                        Add New Role
                    </a>
                @endcan
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left text-gray-700 border border-gray-200 rounded">
                    <thead class="bg-gray-100 text-xs font-semibold uppercase">
                        <tr>
                            <th class="px-6 py-3 border">S#</th>
                            <th class="px-6 py-3 border">Name</th>
                            <th class="px-6 py-3 border w-64">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($roles as $role)
                            <tr class="border-t">
                                <td class="px-6 py-3">{{ $loop->iteration }}</td>
                                <td class="px-6 py-3">{{ $role->name }}</td>
                                <td class="px-6 py-3">
                                    <form action="{{ route('roles.destroy', $role->id) }}" method="POST"
                                        class="flex space-x-2">
                                        @csrf
                                        @method('DELETE')

                                        <a href="{{ route('roles.show', $role->id) }}"
                                            class="px-3 py-1 text-xs bg-yellow-500 text-white rounded hover:bg-yellow-600">
                                            Show
                                        </a>

                                        @if ($role->name != 'Super Admin')
                                            @can('edit-role')
                                                <a href="{{ route('roles.edit', $role->id) }}"
                                                    class="px-3 py-1 text-xs bg-blue-500 text-white rounded hover:bg-blue-600">
                                                    Edit
                                                </a>
                                            @endcan

                                            @can('delete-role')
                                                @if (!Auth::user()->hasRole($role->name))
                                                    <button type="submit"
                                                        onclick="return confirm('Do you want to delete this role?');"
                                                        class="px-3 py-1 text-xs bg-red-600 text-white rounded hover:bg-red-700">
                                                        Delete
                                                    </button>
                                                @endif
                                            @endcan
                                        @endif
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center text-red-600 py-6 font-semibold">
                                    No Role Found!
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-6">
                {{ $roles->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
