<x-app-layout>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
             <!--  Flash Message Components -->
            <x-success-message />
            <x-error-message />
            <!--End Flash Message-->
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <form method="POST" action="{{ route('roles.store') }}">
                        @csrf

                        <!-- Form Header (Title + Back Button) -->
                        <div class="flex justify-between items-center mb-6">
                            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">
                                {{ __('Add New Role') }}
                            </h2>
                            <a href="{{ route('roles.index') }}"
                               class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded hover:bg-blue-700">
                                &larr; Back
                            </a>
                        </div>

                        <!-- Name -->
                        <div class="mb-4">
                            <x-input-label for="name" :value="__('Name')" />
                            <x-text-input id="name" name="name" type="text" class="mt-1 block w-full"
                                :value="old('name')" />
                            <x-input-error :messages="$errors->get('name')" class="mt-2" />
                        </div>

                        <!-- Permissions -->
                        <div class="mb-4">
                            <x-input-label for="permissions" :value="__('Permissions')" />
                            <select id="permissions" name="permissions[]" multiple
                                style="height: 210px;"
                                class="form-select mt-1 block w-full rounded border-gray-300 dark:bg-gray-700 dark:text-white focus:ring focus:ring-blue-500 focus:border-blue-500 @error('permissions') border-red-500 @enderror">
                                @forelse ($permissions as $permission)
                                    <option value="{{ $permission->id }}"
                                        {{ in_array($permission->id, old('permissions') ?? []) ? 'selected' : '' }}>
                                        {{ $permission->name }}
                                    </option>
                                @empty
                                    <option disabled>No permissions available</option>
                                @endforelse
                            </select>
                            <x-input-error :messages="$errors->get('permissions')" class="mt-2" />
                        </div>

                        <!-- Submit Button -->
                        <div class="flex justify-end mt-6">
                            <x-primary-button>
                                {{ __('Add Role') }}
                            </x-primary-button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>
