<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Details - {{ $project->name }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 7px; color: #333; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { border: 1px solid #ccc; padding: 6px 8px; text-align: left; vertical-align: top; }
        th { background-color: #f2f2f2; }
        h2, h3 { margin-bottom: 10px; }
        .section { margin-bottom: 40px; }
        .total-row { font-weight: bold; background-color: #f9f9f9; }
    </style>
</head>
<body>
    {{---Logo--}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    {{-- Project Section --}}
    <div class="section">
        <h2>Project Information</h2>
        <table>
            <tr><th>Name</th><td>{{ $project->name ?? 'N/A' }}</td></tr>
            <tr><th>Location</th><td>{{ $project->location ?? 'N/A' }}</td></tr>
            <tr><th>Type</th><td>{{ ucfirst(str_replace('_', ' ', $project->type)) ?? 'N/A' }}</td></tr>
            <tr><th>Number of Units</th><td>{{ $project->number_of_units ?? 'N/A' }}</td></tr>
            <tr><th>Description</th><td>{{ $project->description ?? 'N/A' }}</td></tr>
        </table>
    </div>

    {{-- Clients Section --}}
    <div class="section">
        <h2>Clients</h2>
        @if ($project->projectClients->isNotEmpty())
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Client Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>Nationality</th>
                        <th>KRA Pin</th>
                        <th>Passport Details</th>
                        <th>Apartment/Subdivision</th>
                        <th>Amount Charged  (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($project->projectClients as $client)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $client->client->user->name ?? 'N/A' }}</td>
                            <td>{{ $client->client->national_id ?? 'N/A' }}</td>
                            <td>{{ $client->client->phone ?? 'N/A' }}</td>
                            <td>{{ $client->client->nationality ?? 'N/A' }}</td>
                            <td>{{ $client->client->kra_pin ?? 'N/A' }}</td>
                            <td>
                                <strong>#:</strong> {{ $client->client->passport_number ?? 'N/A' }}, 
                                <strong>:</strong> {{ $client->client->passport_expiry_date ?? 'N/A' }}
                            </td>
                            @php
                                $apartment = $client->apartmentDetail;
                                $subdivision = $client->subdivisionDetail;
                            @endphp
                            @if ($apartment)
                                <td>
                                    <strong>Floor:</strong> {{ $apartment->floor ?? 'N/A' }}, 
                                    <strong>Unit:</strong> {{ $apartment->flat_name ?? 'N/A' }}, 
                                    <strong>Type:</strong> {{ $apartment->unit_type ?? 'N/A' }}
                                </td>
                                <td>{{ number_format($apartment->amount_charged  ?? 0, 2) }}</td>
                            @elseif ($subdivision)
                                <td>
                                    <strong>Plot:</strong> {{ $subdivision->plot_number ?? 'N/A' }}, 
                                    <strong>Size:</strong> {{ $subdivision->size ?? 'N/A' }}
                                </td>
                                <td>{{ number_format($subdivision->amount_charged ?? 0, 2) }}</td>
                                
                            @else
                                <td>No apartment or subdivision info</td>
                                <td>0.00</td>
                                <td>0.00</td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="8">Total</td>
                        <td>{{ number_format($totalAmountCharged, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        @else
            <p>No clients assigned.</p>
        @endif
    </div>

</body>
</html>