<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Project Expenses - {{ $project->name }}</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 7px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        h2 {
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 40px;
        }

        .total-row {
            font-weight: bold;
            background-color: #f9f9f9;
        }
    </style>
</head>

<body>
    {{-- -Logo --}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    <div class="section">
        <h2>Project Expenses for {{ $project->name }}</h2>
        <p><strong>Location:</strong> {{ $project->location ?? 'N/A' }}</p>
        <p><strong>Date:</strong> {{ now()->format('d/m/Y') }}</p>

        @php
            $totalExpensesPaid = $expenses->sum(fn($expense) => $expense->expense->amount_paid ?? 0);
        @endphp

        @if ($expenses->isNotEmpty())
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Expense Item</th>
                        <th>Amount Paid (KES)</th>
                        <th>Payment Method</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($expenses as $expense)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td class="px-4 py-2">{{ $expense->expense->expenseItem->expense_item ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ number_format($expense->expense->amount_paid ?? 0, 2) }} KES</td>
                            <td class="px-4 py-2">{{ $expense->expense->payment_method ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $expense->expense->status ?? 'N/A' }}</td>

                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="2">Total</td>
                        <td>{{ number_format($totalExpensesPaid, 2) }} KES</td>
                        <td colspan="2"></td>
                    </tr>
                </tfoot>
            </table>
        @else
            <p>No expenses recorded for this project.</p>
        @endif
    </div>
</body>

</html>
