<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Office Utility #{{ $officeutility->id }}</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap');

        body {
            font-family: 'Roboto', sans-serif;
            font-size: 14px;
            line-height: 1.5;
            margin: 0;
            padding: 40px;
            background-color: #f8fafc;
            color: #1e293b;
        }

        .invoice-box {
            max-width: 900px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.05);
            padding: 40px;
            border: 1px solid #e2e8f0;
        }

        .header {
            display: flex;
            flex-direction: column;
            align-items: center;
            border-bottom: 2px solid #e2e8f0;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .header-logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .header-logo img {
            height: 70px;
            width: auto;
        }

        .header-info {
            text-align: center;
            color: #475569;
        }

        .header-info div {
            margin-bottom: 6px;
            font-size: 13px;
        }

        .header-info strong {
            color: #1e293b;
        }

        h1 {
            font-size: 28px;
            color: #1e293b;
            font-weight: 700;
            text-align: center;
            margin: 0 0 20px;
            letter-spacing: 0.5px;
        }

        .section-title {
            font-weight: 500;
            font-size: 15px;
            color: #1e293b;
            margin-bottom: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-left: 4px solid #3b82f6;
            padding-left: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            background-color: #ffffff;
        }

        th, td {
            padding: 14px 20px;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }

        th {
            background-color: #f1f5f9;
            font-weight: 500;
            color: #1e293b;
            text-transform: uppercase;
            font-size: 12px;
            letter-spacing: 0.5px;
        }

        td {
            color: #1e293b;
        }

        .total {
            font-weight: 600;
            background-color: #f8fafc;
            color: #1e293b;
        }

        .text-right {
            text-align: right;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 12px;
            color: #64748b;
            border-top: 1px solid #e2e8f0;
            padding-top: 20px;
            line-height: 1.8;
        }

        .footer a {
            color: #3b82f6;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="invoice-box">
        <div class="header">
            <div class="header-logo">
                <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo">
            </div>
            <div class="header-info">
                <div><strong>Abdullahi Yusuf & Company</strong></div>
                <div>Nyerere Avenue, Mombasa</div>
                <div>info@aycadvocates.com</div>
                <div>+254 725 813 540</div>
            </div>
        </div>

        <h1>Office Utility #{{ $officeutility->id }}</h1>

        <div class="header">
            <div><strong>Date:</strong> {{ $officeutility->created_at->format('F j, Y') }}</div>
        </div>

        <div class="section">
            <div class="section-title">Utility Details</div>
            <table>
                <tr>
                    <th>Type</th>
                    <th>Amount (KES)</th>
                    <th>Period</th>
                </tr>
                <tr>
                    <td>{{ $officeutility->type }}</td>
                    <td class="text-right">{{ number_format($officeutility->amount, 2) }}</td>
                    <td>{{ $officeutility->period }}</td>
                </tr>
                <tr>
                    <td class="total">Total</td>
                    <td class="total text-right">KES {{ number_format($officeutility->amount, 2) }}</td>
                    <td></td>
                </tr>
            </table>
        </div>

        <div class="footer">
            Thank you for your business. <br>
            For inquiries, please contact us at <a href="mailto:info@aycadvocates.com">info@aycadvocates.com</a> or +254 725 813 540. <br>
            © {{ now()->year }} Abdullahi Yusuf & Company. All rights reserved.
        </div>
    </div>
</body>
</html>