<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Litigation Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            text-align: center;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
        }

        th {
            background: #eee;
        }

        h2 {
            margin-top: 30px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    {{---Logo--}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>

    <h1>Litigation Details</h1>
    {{-- --Case - --}}
    <h2>Case Info</h2>
    <table>
        <tr>
            <th>Case Number</th>
            <td>{{ $litigation->case_number }}</td>
        </tr>
        <tr>
            <th>Court Assigned Case Number</th>
            <td>{{ $litigation->court_assigned_case_number }}</td>
        </tr>
        <tr>
            <th>Type</th>
            <td>{{ ucwords(str_replace('_', ' ', $litigation->litigationCaseType->name)) }}</td>
        </tr>
        {{-- <tr>
            <th>Status</th>
            <td>{{ ucwords(str_replace('_', ' ', $litigation->status)) }}</td>
        </tr> --}}
        <tr>
            <th>Description</th>
            <td>{{ $litigation->description }}</td>
        </tr>
        <tr>
            <th>Case Category</th>
            <td>{{ $litigation->litigationCategory->name }}</td>
        </tr>
        <tr>
            <th>Station</th>
            <td>{{ $litigation->station }}</td>
        </tr>
        <tr>
            <th>Filing Date</th>
            <td>{{ \Carbon\Carbon::parse($litigation->filing_date)->format('jS F, Y') }}</td>
        </tr>
    </table>


    {{-- -----Client----- --}}
    @if (!empty($client))
        <h2>Client</h2>
        <table>
            <tr>
                <th>Name</th>
                <td>{{ $litigation->client->user->name ?? '' }}</td>
            </tr>
            <tr>
                <th>Email</th>
                <td>{{ $litigation->client->user->email ?? '' }}</td>
            </tr>
            <tr>
                <th>Phone</th>
                <td>{{ $litigation->client->phone }}</td>
            </tr>
        </table>
    @endif

    {{-- -------Advocates-------- --}}
    @if ($parties->isNotEmpty())
        <h2>Parties</h2>
        <table>
            <thead>
                <tr>
                    <th>Party</th>
                    <th>Party Type</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Gender</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($parties as $party)
                    <tr>
                        <td>{{ $party->party }}</td>
                        <td>{{ ucwords(str_replace('_', ' ', $party->party_type)) }}</td>
                        <td>{{ $party->email }}</td>
                        <td>{{ $party->phone }}</td>
                        <td>{{ ucfirst($party->gender) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif


    {{-- ---------Litigation Stages---------- --}}
    @if ($litigation->litigationActivities && $litigation->litigationActivities->isNotEmpty())
        <h2>Litigation Activities</h2>
        <table>
            <thead>
                <tr>
                    <th>Activity</th>
                    <th>Date</th>
                    <th>Court Room</th>
                    <th>Outcome</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($litigation->litigationActivities as $activity)
                    <tr>
                        <td>{{ $activity->activity }}</td>
                        <td>{{ \Carbon\Carbon::parse($activity->activity_date)->format('F j, Y') }}</td>
                        <td>{{ $activity->court_room }}</td>
                        <td>{{ $activity->outcome }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif



    {{-- ----Payments----- 
    @if ($payments && $payments->isNotEmpty())
        <h2>Payments</h2>
        @php
            $totalPaid = $litigation->litigationPayments->sum('amount_paid');
        @endphp
        <table>
            <thead>
                <tr>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($litigation->litigationPayments as $payment)
                    <tr>
                        <td>{{ ucfirst($payment->payment_method) }}</td>
                        <td>{{ ucfirst($payment->status) }}</td>
                        <td>{{ \Carbon\Carbon::parse($payment->date)->format('F j, Y') }}</td>
                        <td>{{ number_format($payment->amount_paid, 2) }}</td>
                    </tr>
                @endforeach

                {{-- Totals Row (moved outside loop) 
                <tr style="background-color: #f3f3f3; font-weight: bold;">
                    <td colspan="3" style="text-align: right;">Total:</td>
                    <td>{{ number_format($totalPaid, 2) }}</td>
                </tr>
            </tbody>
        </table>
    @endif


    {{-- --Expenses--- 
    @if ($expenses && $expenses->isNotEmpty())

        <h2>Expenses</h2>
        @php
            $totalExpenses = $expenses->sum('amount');
        @endphp
        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($expenses as $expense)
                    <tr>
                        <td>{{ $expense->title }}</td>
                        <td>{{ ucwords(str_replace('_', ' ', $expense->type)) }}</td>
                        <td>{{ number_format($expense->amount, 2) }}</td>
                    </tr>
                @endforeach
                <tr style="background-color: #f3f3f3; font-weight: bold;">
                    <td colspan="2" style="text-align: right;">Total Expenses:</td>
                    <td>{{ number_format($totalExpenses, 2) }}</td>
                </tr>
            </tbody>
        </table>
    @endif
    --}}
</body>

</html>
