<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Litigation Financial Summary</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 13px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
        }

        th {
            background: #eee;
        }

        h1,
        h2 {
            margin-top: 20px;
        }

        .profit {
            color: green;
            font-weight: bold;
        }

        .loss {
            color: red;
            font-weight: bold;
        }
    </style>
</head>

<body>
    {{---Logo--}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>

    <h1>Litigation Financial Summary</h1>

    <h2>Case Info</h2>
    <table>
        <tr>
            <th>System Generated Case Number</th>
            <td>{{ $litigation->case_number }}</td>
        </tr>
        <tr>
            <th>Court Assigned Case Number</th>
            <td>{{ $litigation->court_assigned_case_number }}</td>
        </tr>
        <tr>
            <th>Court</th>
            <td>{{ $litigation->station }}</td>
        </tr>
       
        <tr>
            <th>Description</th>
            <td>{{ $litigation->description }}</td>
        </tr>
    </table>

    @php
        $totalPaid = $payments->sum('amount_paid');
        $totalExpenses = $litigation->litigationExpenses->sum(function ($litigationExpense) {
            if (!$litigationExpense->expense) {
                \Log::warning(
                    'Missing Expense for LitigationExpense ID: ' .
                        $litigationExpense->id .
                        ', Litigation ID: ' .
                        $litigationExpense->litigation_id,
                );
                return 0;
            }
            return $litigationExpense->expense->amount_paid;
        });
        $net = $totalPaid - $totalExpenses;
    @endphp

    <h2>Summary</h2>
    <table>
        <tr>
            <th>Total Payments Received</th>
            <td>{{ number_format($totalPaid, 2) }}</td>
        </tr>
        <tr>
            <th>Total Expenses</th>
            <td>{{ number_format($totalExpenses, 2) }}</td>
        </tr>
        <tr>
            <th> Profit / Loss</th>
            <td>
                 {{ number_format(abs($net), 2) }}
            </td>
        </tr>
    </table>

    @if ($payments->count())
        <h2>Payment Breakdown</h2>
        <table>
            <thead>
                <tr>
                    <th>Payer Name</th>
                    <th>Method</th>
                    <th>Transaction ID</th>
                    <th>Type</th>
                    <th>Amount Paid</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($payments as $payment)
                    <tr>
                        <td>{{ optional(optional($payment->client)->user)->name ?? 'N/A' }}</td>
                        <td>{{ ucfirst($payment->payment_method) }}</td>
                        <td>{{ $payment->transaction_id }}</td>
                        <td>{{ ucfirst(str_replace('_', ' ', $payment->type)) }}</td>
                        <td>{{ number_format($payment->amount_paid, 2) }}</td>
                        <td>{{ $payment->created_at ? \Carbon\Carbon::parse($payment->created_at)->format('F j, Y') : '' }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    @if ($litigation->litigationExpenses->count())
        <h2>Expense Breakdown</h2>
        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Amount (Ksh)</th>
                    <th>Payment Method</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($litigation->litigationExpenses as $litigationExpense)
                    <tr>
                        <td>
                            @if ($litigationExpense->expense && $litigationExpense->expense->expenseItem)
                                {{ $litigationExpense->expense->expenseItem->expense_item }}
                            @else
                                N/A (Missing Expense ID: {{ $litigationExpense->expense_id }})
                            @endif
                        </td>
                        <td>{{ $litigationExpense->expense ? number_format($litigationExpense->expense->amount_paid, 2) : '0.00' }}
                        </td>
                        <td>{{ $litigationExpense->expense ? ucfirst($litigationExpense->expense->payment_method ?? 'N/A') : 'N/A' }}
                        </td>
                        <td>{{ $litigationExpense->expense && $litigationExpense->expense->created_at ? $litigationExpense->expense->created_at->format('F j, Y') : 'N/A' }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <h2>Expense Breakdown</h2>
        <p>No expenses found for this litigation.</p>
    @endif

</body>

</html>
