<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Conveyancing Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;

        }

        .payments-table,
        .advocates-table {
            text-align: center;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 8px;
        }

        th {
            background: #eee;
        }

        h2 {
            margin-top: 30px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    {{-- -Logo --}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    <h1>Conveyancing Details</h1>

    <h2>Transaction Info</h2>
    <table>
        <tr>
            <th>Referrence Number</th>
            <td>{{ $record->serial_number ?? 'N/A' }}</td>
        </tr>
        <tr>
            <th>Property Details</th>
            <td>{{ $record->property_address }}</td>
        </tr>
        <tr>
            <th>Sale Price</th>
            <td>{{ number_format($record->sale_price, 2) }}</td>
        </tr>

        <tr>
            <th>Contract Date</th>
            <td>{{ $record->contract_date ? \Carbon\Carbon::parse($record->contract_date)->format('F j, Y') : '' }}</td>
        </tr>
        <tr>
            <th>Completion Period</th>
            <td>{{ $record->completion_period ? \Carbon\Carbon::parse($record->settlement_date)->format('F j, Y') : '' }}
            </td>
        </tr>
        <tr>
            <th>Notes</th>
            <td>{{ $record->notes }}</td>
        </tr>
    </table>

    @if ($client)
        <h2>Client</h2>
        <table>
            <tr>
                <th>Name</th>
                <td>{{ $client->user->name ?? '' }}</td>
            </tr>
            <tr>
                <th>Email</th>
                <td>{{ $client->user->email ?? '' }}</td>
            </tr>
            <tr>
                <th>Phone</th>
                <td>{{ $client->phone }}</td>
            </tr>
            <tr>
                <th>National ID</th>
                <td>{{ $client->national_id }}</td>
            </tr>
            <tr>
                <th>Address</th>
                <td>{{ $client->address }}</td>
            </tr>
        </table>
    @endif

    @if ($record->buyer || $record->seller)
        <h2>Parties</h2>
        <table>
            <tr>
                <th>Buyer Name</th>
                <td>{{ $record->buyer?->user?->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Seller Name</th>
                <td>{{ $record->seller?->user?->name ?? 'N/A' }}</td>
            </tr>
        </table>
    @endif


    @if ($advocates->isNotEmpty())
        {{-- <div class="page-break"></div> --}}
        <h2>Advocates</h2>
        <table class="advocates-table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Role</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($advocates as $advocate)
                    <tr>
                        <td>{{ $advocate->advocate->user->name ?? '' }}</td>
                        <td>{{ $advocate->role }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
    @if ($expenses->count())
        <h2>Expenses</h2>
        <table class="payments-table">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Amount (KES)</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($expenses as $expense)
                    <tr>
                        <td>{{ $expense->expenseItem->expense_item ?? 'Other' }}</td>
                        <td>{{ number_format($expense->amount_paid, 2) }}</td>
                    </tr>
                @endforeach
                <tr style="background:#eee; font-weight:bold;">
                    <td>Total Expenses</td>
                    <td>{{ number_format($expenses->sum('amount_paid'), 2) }}</td>
                </tr>
            </tbody>
        </table>
    @endif


</body>

</html>
