<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Client Financial Report</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        h1, h2 { color: #1a3c6e; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 40px; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .section { margin-bottom: 50px; }
        .header { text-align: center; margin-bottom: 30px; }
        .total-row { font-weight: bold; background-color: #e6f3ff; }
        .balance-row { font-weight: bold; background-color: #f0f8ff; }
    </style>
</head>
<body>
    {{---Logo--}}
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="{{ public_path('images/logo.png') }}" alt="AYC Lawfirm Logo" style="height: 60px; margin-bottom: 20px;">
    </div>
    
    <div class="header">
        <h1>Client Financial Report</h1>
        <h2>{{ $client->user->name ?? 'Client' }} (ID: {{ $client->id }})</h2>
    </div>

    <!-- Conveyancing Payments Section -->
    @if($conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0 ||
        $conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0 ||
        $conveyancingPayments->where('paid_by', '!=', $client->id)->count() > 0)
        <div class="section">
            <h2>Conveyancing Payments</h2>

            <!-- Purchase Price Paid to Owner -->
            @if($conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0)
                <h3>Purchase Price Paid to Owner</h3>
                @foreach($conveyancingPayments->where('type', 'purchase_price')->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->groupBy('conveyancing_id') as $conveyancingId => $payments)
                    @php
                        $conveyancing = $payments->first()->conveyancing;
                        $salePrice = $conveyancing->sale_price ?? 0;
                        $totalPaid = $payments->sum('amount_paid');
                        $balance = ($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id) ? $salePrice - $totalPaid : 0;
                    @endphp
                    <h4>{{ $conveyancing->property_address ?? 'Conveyancing' }} (Serial: {{ $conveyancing->serial_number ?? 'N/A' }}) - Owner: {{ $conveyancing->client->user->name ?? 'N/A' }}</h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Property Address</th>
                                <th>Owner</th>
                                <th>Amount Paid</th>
                                <th>Paid By</th>
                                <th>Transaction ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($payments as $payment)
                                <tr>
                                    <td>{{ $payment->conveyancing->serial_number ?? 'N/A' }}</td>
                                    <td>{{ $payment->conveyancing->property_address ?? 'N/A' }}</td>
                                    <td>{{ $payment->conveyancing->client->user->name ?? 'N/A' }}</td>
                                    <td>{{ number_format($payment->amount_paid, 2) }}</td>
                                    <td>{{ $payment->paidBy->user->name ?? 'N/A' }}</td>
                                    <td>{{ $payment->transaction_id }}</td>
                                </tr>
                            @endforeach
                            <tr class="total-row">
                                <td colspan="3">Total</td>
                                <td>{{ number_format($totalPaid, 2) }}</td>
                                <td colspan="2"></td>
                            </tr>
                            @if($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id)
                                <tr class="balance-row">
                                    <td colspan="3">Balance (Sale Price: {{ number_format($salePrice, 2) }})</td>
                                    <td>{{ number_format($balance, 2) }}</td>
                                    <td colspan="2"></td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                @endforeach
            @endif

            <!-- Payments Made -->
            @if($conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->count() > 0)
                <h3>Payments Made</h3>
                @foreach($conveyancingPayments->where('paid_by', $client->id)->where('client_id', '!=', $client->id)->groupBy('conveyancing_id') as $conveyancingId => $payments)
                    @php
                        $conveyancing = $payments->first()->conveyancing;
                        $agreedFees = $client->id == $conveyancing->buyer_id ? ($conveyancing->buyer_legal_fees ?? 0) : ($conveyancing->seller_legal_fees ?? 0);
                        $totalPaid = $payments->sum('amount_paid');
                        $balance = $agreedFees - $totalPaid;
                    @endphp
                    <h4>{{ $conveyancing->property_address ?? 'Conveyancing' }} (Serial: {{ $conveyancing->serial_number ?? 'N/A' }}) - Owner: {{ $conveyancing->client->user->name ?? 'N/A' }}</h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Property Address</th>
                                <th>Owner</th>
                                <th>Amount Paid</th>
                                <th>Paid By</th>
                                <th>Payment Type</th>
                                <th>Transaction ID</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($payments as $payment)
                                <tr>
                                    <td>{{ $payment->conveyancing->serial_number ?? 'N/A' }}</td>
                                    <td>{{ $payment->conveyancing->property_address ?? 'N/A' }}</td>
                                    <td>{{ $payment->conveyancing->client->user->name ?? 'N/A' }}</td>
                                    <td>{{ number_format($payment->amount_paid, 2) }}</td>
                                    <td>{{ $payment->paidBy->user->name ?? 'N/A' }}</td>
                                    <td>{{ $payment->type == 'legal_fees' ? 'Legal Fees' : 'Purchase Price' }}</td>
                                    <td>{{ $payment->transaction_id }}</td>
                                </tr>
                            @endforeach
                            <tr class="total-row">
                                <td colspan="3">Total</td>
                                <td>{{ number_format($totalPaid, 2) }}</td>
                                <td colspan="3"></td>
                            </tr>
                            <tr class="balance-row">
                                <td colspan="3">Balance (Agreed Legal Fees: {{ number_format($agreedFees, 2) }})</td>
                                <td>{{ number_format($balance, 2) }}</td>
                                <td colspan="3"></td>
                            </tr>
                        </tbody>
                    </table>
                @endforeach
            @endif

            <!-- Purchase Price Received -->
            @if($conveyancingPayments->where('paid_by', '!=', $client->id)->count() > 0)
                <h3>Purchase Price Received</h3>
                @foreach($conveyancingPayments->where('paid_by', '!=', $client->id)->groupBy('conveyancing_id') as $conveyancingId => $payments)
                    @php
                        $conveyancing = $payments->first()->conveyancing;
                        $salePrice = $conveyancing->sale_price ?? 0;
                        $totalReceived = $payments->sum('amount_paid');
                        $balance = ($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id) ? $salePrice - $totalReceived : 0;
                    @endphp
                    <h4>{{ $conveyancing->property_address ?? 'Conveyancing' }} (Serial: {{ $conveyancing->serial_number ?? 'N/A' }}) - Owner: {{ $conveyancing->client->user->name ?? 'N/A' }}</h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Paid To</th>
                                <th>Amount Received</th>
                                <th>Paid By</th>
                                <th>Payment Method</th>
                                <th>Transaction ID</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($payments as $payment)
                                <tr>
                                    <td>{{ $payment->client->user->name ?? 'N/A' }}</td>
                                    <td>{{ number_format($payment->amount_paid, 2) }}</td>
                                    <td>{{ $payment->paidBy->user->name ?? 'N/A' }}</td>
                                    <td>{{ $payment->payment_method }}</td>
                                    <td>{{ $payment->transaction_id }}</td>
                                    <td>{{ $payment->created_at->format('F j, Y') }}</td>
                                </tr>
                            @endforeach
                            <tr class="total-row">
                                <td colspan="1">Total</td>
                                <td>{{ number_format($totalReceived, 2) }}</td>
                                <td colspan="4"></td>
                            </tr>
                            @if($client->id == $conveyancing->client_id || $client->id == $conveyancing->buyer_id)
                                <tr class="balance-row">
                                    <td colspan="1">Balance (Sale Price: {{ number_format($salePrice, 2) }})</td>
                                    <td>{{ number_format($balance, 2) }}</td>
                                    <td colspan="4"></td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                @endforeach
            @endif
        </div>
    @endif

    <!-- Litigation Payments Section -->
    @if($litigationPayments->count() > 0)
        <div class="section">
            <h2>Litigation Payments</h2>
            @foreach($litigationPayments->groupBy('litigation_id') as $litigationId => $payments)
                <h4>{{ $payments->first()->litigation->name ?? 'Litigation' }} (Case Number: {{ $payments->first()->litigation->case_number ?? 'N/A' }})</h4>
                <table>
                    <thead>
                        <tr>
                            <th>Case Number</th>
                            <th>Litigation Name</th>
                            <th>Amount Paid</th>
                            <th>Transaction ID</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payments as $payment)
                            <tr>
                                <td>{{ $payment->litigation->case_number ?? 'N/A' }}</td>
                                <td>{{ $payment->litigation->description ?? 'N/A' }}</td>
                                <td>{{ number_format($payment->amount_paid, 2) }}</td>
                                <td>{{ $payment->transaction_id }}</td>
                                <td>{{ $payment->created_at->format('F j, Y') }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row">
                            <td colspan="2">Total</td>
                            <td>{{ number_format($payments->sum('amount_paid'), 2) }}</td>
                            <td colspan="2"></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
        </div>
    @endif

    <!-- Project Client Payments Section -->
    @if($projectClientPayments->count() > 0)
        <div class="section">
            <h2>Project Client Payments</h2>
            @foreach($projectClientPayments->groupBy('projectClient.project.id') as $projectId => $payments)
                <h4>{{ $payments->first()->projectClient->project->name ?? 'Unknown Project' }} (ID: {{ $projectId ?? 'N/A' }})</h4>
                <table>
                    <thead>
                        <tr> 
                            <th>Project Name</th>
                            <th>Amount Paid</th>
                            <th>Payment Method</th>
                            <th>Transaction ID</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payments as $payment)
                            <tr>
                                <td>{{ $payment->projectClient->project->name ?? 'N/A' }}</td>
                                <td>{{ number_format($payment->amount_paid, 2) }}</td>
                                <td>{{ $payment->payment_method ?? 'N/A' }}</td>
                                <td>{{ $payment->transaction_id ?? 'N/A' }}</td>
                                <td>{{ $payment->created_at ? $payment->created_at->format('F j, Y') : 'N/A' }}</td>
                            </tr>
                        @endforeach
                        <tr class="total-row">
                            <td colspan="2">Total</td>
                            <td>{{ number_format($payments->sum('amount_paid'), 2) }}</td>
                            <td colspan="3"></td>
                        </tr>
                    </tbody>
                </table>
            @endforeach
        </div>
    @endif

    <!-- No Data Message -->
    @if($conveyancingPayments->count() == 0 && $litigationPayments->count() == 0 && $projectClientPayments->count() == 0)
        <p>No report for the user {{ $client->user->name ?? 'Client' }}.</p>
    @endif
</body>
</html>