{{-- User Details Table --}}
<div class="overflow-x-auto mb-6">
    <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mb-2">User Details</h2>

    <table class="w-full min-w-full text-sm text-left border border-gray-300 dark:border-gray-700 border-collapse">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="px-4 py-2">Name</th>
                <th class="px-4 py-2">Email</th>
                <th class="px-4 py-2">Roles</th>
                <th class="px-4 py-2">Created At</th>
                <th class="px-4 py-2">Updated At</th>
            </tr>
        </thead>
        <tbody class="divide-y dark:divide-gray-700">
            <tr>
                <td class="px-4 py-2 font-medium text-gray-900 dark:text-white">
                    {{ $record->name }}
                </td>
                <td class="px-4 py-2 text-gray-700 dark:text-gray-300">
                    {{ $record->email }}
                </td>
                <td class="px-4 py-2">
                    @if ($record->roles->isNotEmpty())
                        <div class="flex flex-wrap gap-2">
                            @foreach ($record->roles as $role)
                                <x-filament::badge color="primary">
                                    {{ ucfirst($role->name) }}
                                </x-filament::badge>
                            @endforeach
                        </div>
                    @else
                        <span class="text-gray-500 italic">No roles assigned</span>
                    @endif
                </td>
                <td class="px-4 py-2">
                    {{ $record->created_at->format('d M Y, H:i') }}
                </td>
                <td class="px-4 py-2">
                    {{ $record->updated_at->format('d M Y, H:i') }}
                </td>
            </tr>
        </tbody>
    </table>
</div>

{{-- Permissions Table --}}
<div class="overflow-x-auto">
    <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-200 mb-2">Permissions</h2>

    <table class="w-full text-sm text-left border border-gray-300 dark:border-gray-700 border-collapse">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="px-4 py-2">Permission Name(s)</th>
            </tr>
        </thead>
        <tbody class="divide-y dark:divide-gray-700">
            <tr>
                <td class="px-4 py-2">
                    @php
                        $permissions = $record->getAllPermissions();
                    @endphp

                    @if ($permissions->isNotEmpty())
                        <div class="flex flex-wrap gap-2">
                            @foreach ($permissions as $permission)
                                <x-filament::badge color="success">
                                    {{ ucfirst($permission->name) }}
                                </x-filament::badge>
                            @endforeach
                        </div>
                    @else
                        <span class="text-gray-500 italic">No permissions assigned</span>
                    @endif
                </td>
            </tr>
        </tbody>
    </table>
</div>
