<x-filament::card>
    <div class="overflow-x-auto">
        <table class="w-full min-w-full text-sm text-left">
            <thead class="bg-gray-100 dark:bg-gray-800">
                <tr>
                    <th class="px-4 py-2">Name</th>
                    <th class="px-4 py-2">Category</th>
                    <th class="px-4 py-2">Base Price</th>
                    <th class="px-4 py-2">Billing Type</th>
                    <th class="px-4 py-2">Duration</th>
                </tr>
            </thead>
            <tbody class="divide-y dark:divide-gray-700">
                <tr>
                    <td class="px-4 py-2">{{ $record->name }}</td>
                    <td class="px-4 py-2">{{ $record->serviceCategory->name ?? '-' }}</td>
                    <td class="px-4 py-2">KES {{ number_format($record->base_price, 2) }}</td>
                    <td class="px-4 py-2">
                        <x-filament::badge color="primary">
                            {{ ucfirst($record->billing_type) }}
                        </x-filament::badge>
                    </td>
                    <td class="px-4 py-2">{{ $record->duration_estimate }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</x-filament::card>
