@php
    // Use passed expenses or fallback
    $expenses = $expenses ?? collect();

    // Calculate total expenses
    $totalExpenses = $expenses->sum('amount_paid');
@endphp

<div class="p-4">
    @if ($expenses->isEmpty())
        <p class="text-gray-500 dark:text-gray-400">No expenses found for this project.</p>
    @else
        <!-- Expenses Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">Expense</th>
                        <th class="px-4 py-2 text-left">Amount Paid</th>
                        <th class="px-4 py-2 text-left">Payment Method</th>
                        {{-- <th class="px-4 py-2 text-left">Status</th> --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($expenses as $expense)
                        <tr class="border-t dark:border-gray-600">
                            <td class="px-4 py-2">{{ $expense->expenseItem->expense_item ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ number_format($expense->amount_paid ?? 0, 2) }} KES</td>
                            <td class="px-4 py-2">{{ $expense->payment_method ?? 'N/A' }}</td>
                            {{-- <td class="px-4 py-2">{{ $expense->status ?? 'N/A' }}</td> --}}
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="bg-gray-50 dark:bg-gray-800 font-bold">
                        <td class="px-4 py-2">Total</td>
                        <td class="px-4 py-2">{{ number_format($totalExpenses, 2) }} KES</td>
                        <td class="px-4 py-2" colspan="2"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endif
</div>
