@push('styles')
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 5px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        h2,
        h3 {
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 40px;
        }

        .pdf-icon {
            width: 20px;
            height: 20px;
            vertical-align: middle;
        }
    </style>
@endpush

@php
    // Use project if passed, otherwise fall back to projectRecord
    $projectData = $project ?? ($projectRecord ?? null);
    $document = $document ?? ($projectData->document ?? null);
@endphp

<div class="p-4">
    @if (!$projectData)
        <p class="text-gray-500 dark:text-gray-400">No project details found.</p>
    @else
        @if (!empty($projectData->serial_number))
            <div class="mb-4 text-center">
                <h2 class="text-lg font-semibold text-gray-800 dark:text-white">
                    Referrence Number: <span
                        class="text-primary-600 dark:text-primary-400">{{ $projectData->serial_number }}</span>
                </h2>
            </div>
        @endif

        <!-- Project Details Table -->
        <div class="overflow-x-auto">
            <table class="w-full min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">Project Name</th>
                        <th class="px-4 py-2 text-left">Point of Contact</th>
                        <th class="px-4 py-2 text-left">Location</th>
                        <th class="px-4 py-2 text-left">Number of Units</th>
                        <th class="px-4 py-2 text-left">Type</th>
                        <th class="px-4 py-2 text-left">Description</th>
                        <th class="px-4 py-2 text-left">Documents</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border-t dark:border-gray-600">
                        <td class="px-4 py-2">{{ $projectData->name ?? 'N/A' }}</td>
                        <td class="px-4 py-2">{{ $projectData->poc ?? 'N/A' }}</td>
                        <td class="px-4 py-2">{{ $projectData->location ?? 'N/A' }}</td>
                        <td class="px-4 py-2">{{ $projectData->number_of_units ?? 'N/A' }}</td>
                        <td class="px-4 py-2">{{ ucfirst($projectData->type ?? 'N/A') }}</td>
                        <td class="px-4 py-2">{{ $projectData->description ?? 'N/A' }}</td>
                        <td class="px-4 py-2">
                            @if ($documents && $documents->isNotEmpty())
                                @foreach ($documents as $document)
                                    @php
                                        $extension = strtolower(pathinfo($document->file_path, PATHINFO_EXTENSION));

                                        $iconMap = [
                                            'pdf' => 'pdf-icon.png',
                                            'doc' => 'word-icon.png',
                                            'docx' => 'word-icon.png',
                                            'xls' => 'excel-icon.png',
                                            'xlsx' => 'excel-icon.png',
                                            'jpg' => 'image-icon.png',
                                            'jpeg' => 'image-icon.png',
                                            'png' => 'image-icon.png',
                                            'txt' => 'text-icon.png',
                                        ];

                                        $icon = $iconMap[$extension] ?? 'file-icon.png'; // fallback
                                    @endphp

                                    <div class="mb-2">
                                        <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank"
                                            class="flex items-center">
                                            <img src="{{ asset('images/' . $icon) }}" alt="{{ strtoupper($extension) }}"
                                                class="pdf-icon">
                                        </a>
                                        <p>{{ $document->name }}</p>
                                    </div>
                                @endforeach
                            @else
                                N/A
                            @endif
                        </td>

                    </tr>
                </tbody>
            </table>
        </div>
    @endif
</div>
