<!-- resources/views/infolists/project-components/project-clients-table.blade.php -->
@push('styles')
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 5px;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        h2,
        h3 {
            margin-bottom: 10px;
        }

        .section {
            margin-bottom: 40px;
        }

        .pdf-icon {
            width: 20px;
            height: 20px;
            vertical-align: middle;
        }
    </style>
@endpush
@php
    // Use projectClients if passed, otherwise fall back to projectRecord->projectClients
    $clients = $projectClients ?? ($projectRecord->projectClients ?? collect());
@endphp

<div class="p-4">
    @if ($clients->isEmpty())
        <p class="text-gray-500 dark:text-gray-400">No clients found for this project.</p>
    @else
        <!-- Clients Table -->
        <div class="overflow-x-auto">
            <table class="w-full min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">#</th> {{-- Row Number --}}
                        <th>Client Name</th>
                        <th>ID</th>
                        <th>Phone</th>
                        <th>KRA Pin</th>
                        <th>Apartment/Subdivision</th>
                        <th>Amount Charged</th>
                        <th>Document</th>
                        <th>Project Cient Report</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clients as $projectClient)
                        <tr class="border-t dark:border-gray-600">
                            <td class="px-4 py-2">{{ $loop->iteration }}</td> {{-- Incrementing number --}}
                            <td class="px-4 py-2">

                                <a href="{{ route('filament.admin.resources.clients.view', $projectClient->client->id) }}"
                                    class="text-blue-600 hover:underline">
                                    {{ $projectClient->client->user->name ?? 'N/A' }}
                                </a>
                            </td>
                            <td class="px-4 py-2">{{ $projectClient->client->national_id ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $projectClient->client->phone ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $projectClient->client->kra_pin }}</td>
                            @php
                                $apartment = $projectClient->apartmentDetail;
                                $subdivision = $projectClient->subdivisionDetail;
                                $documents = $projectClient->documents;
                            @endphp
                            @if ($apartment)
                                <td>
                                    <strong> Floor : </strong> {{ $apartment->floor ?? 'N/A' }},
                                    <strong> Unit : </strong> {{ $apartment->flat_name ?? 'N/A' }},
                                    <strong> Type : </strong> {{ $apartment->unit_type ?? 'N/A' }}
                                </td>
                                <td>{{ number_format($apartment->amount_charged ?? 0, 2) }}</td>
                            @elseif ($subdivision)
                                <td>
                                    <strong> Plot : </strong> {{ $subdivision->plot_number ?? 'N/A' }},
                                    <strong> Size : </strong> {{ $subdivision->size ?? 'N/A' }} ,
                                </td>
                                <td>{{ number_format($subdivision->amount_charged ?? 0, 2) }}</td>
                            @else
                                <td colspan="3">No apartment or subdivision info</td>
                            @endif

                            <td>
                                @if ($documents && $documents->isNotEmpty())
                                    @foreach ($documents as $document)
                                        <div class="mb-2">
                                            <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank"
                                                class="flex items-center">
                                                <img src="{{ asset('images/pdf-icon.png') }}" alt="PDF"
                                                    class="pdf-icon">
                                            </a>
                                            <p>{{ $document->name }}</p>
                                        </div>
                                    @endforeach
                                @else
                                    N/A
                                @endif
                            </td>


                            <td class="px-4 py-2">
                                <a href="{{ route('filament.resources.projects.client-pdf', ['record' => $projectRecord->id, 'projectClient' => $projectClient->id]) }}"
                                    target="_blank"
                                    class="inline-flex items-center px-3 py-1 text-sm font-medium rounded-lg bg-primary-600 text-white hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500">
                                    {{-- {{ ' Download ' . $projectClient->client->user->name . ' Report' ?? 'N/A' }} --}}
                                    Download 
                                </a>
                            </td>


                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>
