<!-- resources/views/infolists/project-components/project-client-payments-table.blade.php -->
@php
    // Collect all project client payments from projectClients
    $payments = $projectClients->flatMap->projectClientPayments ?? collect();
@endphp

<div class="p-4">
    @if($payments->isEmpty())
        <p class="text-gray-500 dark:text-gray-400">No client payments found for this project.</p>
    @else
        <!-- Client Payments Table -->
        <div class="overflow-x-auto">
            <table class="w-full min-w-full table-auto border border-gray-200 dark:border-gray-700 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-900/50">
                    <tr>
                        <th class="px-4 py-2 text-left">Client Name</th>
                        <th class="px-4 py-2 text-left">Payment Method</th>
                        <th class="px-4 py-2 text-left">Transaction ID</th>
                        <th class="px-4 py-2 text-left">Status</th>
                        <th class="px-4 py-2 text-left">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payments as $payment)
                        @php
                            // Find the client associated with this payment
                            $client = $projectClients->firstWhere('id', $payment->project_client_id);
                        @endphp
                        <tr class="border-t dark:border-gray-600">
                            <td class="px-4 py-2">{{ $client ? ($client->client->user->name ?? 'N/A') : 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $payment->payment_method ? ucfirst($payment->payment_method) : 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $payment->transaction_id ?? 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $payment->status ? ucfirst($payment->status) : 'N/A' }}</td>
                            <td class="px-4 py-2">{{ $payment->amount_paid ? number_format($payment->amount_paid, 2) . ' KES' : 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>